/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

final class ChunkedInputStream
extends InputStream {
    private final InputStream origin;
    private int size;
    private int pos;
    private boolean bof = true;
    private boolean eof;

    ChunkedInputStream(InputStream stream) {
        this.origin = stream;
    }

    @Override
    public int read() throws IOException {
        int result;
        if (!this.eof && this.pos >= this.size) {
            this.nextChunk();
        }
        if (this.eof) {
            result = -1;
        } else {
            ++this.pos;
            result = this.origin.read();
        }
        return result;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int result;
        if (!this.eof && this.pos >= this.size) {
            this.nextChunk();
        }
        if (this.eof) {
            result = -1;
        } else {
            int shift = Math.min(len, this.size - this.pos);
            int count = this.origin.read(buf, off, shift);
            this.pos += count;
            result = shift == len ? len : shift + this.read(buf, off + shift, len - shift);
        }
        return result;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    private void readCrlf() throws IOException {
        int crsymbol = this.origin.read();
        int lfsymbol = this.origin.read();
        if (crsymbol != 13 || lfsymbol != 10) {
            throw new IOException(String.format("%s %d%s%d", "CRLF expected at end of chunk: ", crsymbol, "/", lfsymbol));
        }
    }

    private void nextChunk() throws IOException {
        if (!this.bof) {
            this.readCrlf();
        }
        this.size = ChunkedInputStream.chunkSize(this.origin);
        this.bof = false;
        this.pos = 0;
        if (this.size == 0) {
            this.eof = true;
        }
    }

    private static int chunkSize(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = ChunkedInputStream.sizeLine(stream);
        String data = baos.toString(Charset.defaultCharset().name());
        int separator = data.indexOf(59);
        try {
            int result = separator > 0 ? Integer.parseInt(data.substring(0, separator).trim(), 16) : Integer.parseInt(data.trim(), 16);
            return result;
        }
        catch (NumberFormatException ex) {
            throw new IOException(String.format("Bad chunk size: %s", baos.toString(Charset.defaultCharset().name())), ex);
        }
    }

    private static ByteArrayOutputStream sizeLine(InputStream stream) throws IOException {
        State state = State.NORMAL;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        while (state != State.END) {
            state = ChunkedInputStream.next(stream, state, result);
        }
        return result;
    }

    private static State next(InputStream stream, State state, ByteArrayOutputStream line) throws IOException {
        State result;
        int next = stream.read();
        if (next == -1) {
            throw new IOException("chunked stream ended unexpectedly");
        }
        switch (state) {
            case NORMAL: {
                result = ChunkedInputStream.nextNormal(state, line, next);
                break;
            }
            case R: {
                if (next == 10) {
                    result = State.END;
                    break;
                }
                throw new IOException(String.format("%s%s", "Protocol violation: Unexpected", " single newline character in chunk size"));
            }
            case QUOTED_STRING: {
                result = ChunkedInputStream.nextQuoted(stream, state, line, next);
                break;
            }
            default: {
                throw new IllegalStateException("Bad state");
            }
        }
        return result;
    }

    private static State nextNormal(State state, ByteArrayOutputStream line, int next) {
        State result;
        switch (next) {
            case 13: {
                result = State.R;
                break;
            }
            case 34: {
                result = State.QUOTED_STRING;
                break;
            }
            default: {
                result = state;
                line.write(next);
            }
        }
        return result;
    }

    private static State nextQuoted(InputStream stream, State state, ByteArrayOutputStream line, int next) throws IOException {
        State result;
        switch (next) {
            case 92: {
                result = state;
                line.write(stream.read());
                break;
            }
            case 34: {
                result = State.NORMAL;
                break;
            }
            default: {
                result = state;
                line.write(next);
            }
        }
        return result;
    }

    private static enum State {
        NORMAL,
        R,
        QUOTED_STRING,
        END;

    }
}

