/*
 * Decompiled with CFR 0.152.
 */
package org.takes.misc;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.takes.misc.VerboseIterator;

public final class VerboseList<T>
implements List<T> {
    private final List<T> origin;
    private final String message;

    public VerboseList(List<T> list, String msg) {
        this.origin = list;
        this.message = msg;
    }

    @Override
    public int size() {
        return this.origin.size();
    }

    @Override
    public boolean isEmpty() {
        return this.origin.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.origin.contains(obj);
    }

    @Override
    public Iterator<T> iterator() {
        return new VerboseIterator<T>(this.origin.iterator(), this.message);
    }

    @Override
    public Object[] toArray() {
        return this.origin.toArray();
    }

    @Override
    public <E> E[] toArray(E[] arr) {
        return this.origin.toArray(arr);
    }

    @Override
    public boolean add(T item) {
        return this.origin.add(item);
    }

    @Override
    public boolean remove(Object obj) {
        return this.origin.remove(obj);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.origin.containsAll(coll);
    }

    @Override
    public boolean addAll(Collection<? extends T> coll) {
        return this.origin.addAll(coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> coll) {
        try {
            return this.origin.addAll(index, coll);
        }
        catch (IndexOutOfBoundsException ex) {
            throw this.wrapException(ex);
        }
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.origin.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.origin.retainAll(coll);
    }

    @Override
    public void clear() {
        this.origin.clear();
    }

    @Override
    public T get(int index) {
        try {
            return this.origin.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            throw this.wrapException(ex);
        }
    }

    @Override
    public T set(int index, T element) {
        try {
            return this.origin.set(index, element);
        }
        catch (IndexOutOfBoundsException ex) {
            throw this.wrapException(ex);
        }
    }

    @Override
    public void add(int index, T element) {
        try {
            this.origin.add(index, element);
        }
        catch (IndexOutOfBoundsException ex) {
            throw this.wrapException(ex);
        }
    }

    @Override
    public T remove(int index) {
        try {
            return this.origin.remove(index);
        }
        catch (IndexOutOfBoundsException ex) {
            throw this.wrapException(ex);
        }
    }

    @Override
    public int indexOf(Object obj) {
        return this.origin.indexOf(obj);
    }

    @Override
    public int lastIndexOf(Object obj) {
        return this.origin.lastIndexOf(obj);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.origin.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        try {
            return this.origin.listIterator(index);
        }
        catch (IndexOutOfBoundsException ex) {
            throw this.wrapException(ex);
        }
    }

    @Override
    public List<T> subList(int fridx, int toidx) {
        try {
            return this.origin.subList(fridx, toidx);
        }
        catch (IndexOutOfBoundsException ex) {
            throw this.wrapException(ex);
        }
    }

    private IndexOutOfBoundsException wrapException(IndexOutOfBoundsException cause) {
        IndexOutOfBoundsException exc = new IndexOutOfBoundsException(this.message);
        exc.initCause(cause);
        return exc;
    }
}

