/*
 * Decompiled with CFR 0.152.
 */
package org.takes.misc;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.takes.misc.Opt;
import org.takes.misc.VerboseIterable;

public final class Href
implements CharSequence {
    private static final Pattern TRAILING_SLASH = Pattern.compile("/$");
    private final URI uri;
    private final SortedMap<String, List<String>> params;
    private final Opt<String> fragment;

    public Href() {
        this("/");
    }

    public Href(CharSequence txt) {
        this(Href.createUri(txt.toString()));
    }

    private Href(URI link) {
        this(Href.createBare(link), Href.asMap(link.getRawQuery()), Href.readFragment(link));
    }

    private Href(URI link, SortedMap<String, List<String>> map, Opt<String> frgmnt) {
        this.uri = link;
        this.params = map;
        this.fragment = frgmnt;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder(this.bare());
        if (!this.params.isEmpty()) {
            boolean first = true;
            for (Map.Entry<String, List<String>> ent : this.params.entrySet()) {
                for (String value : ent.getValue()) {
                    if (first) {
                        text.append('?');
                        first = false;
                    } else {
                        text.append('&');
                    }
                    text.append(Href.encode(ent.getKey()));
                    if (value.isEmpty()) continue;
                    text.append('=').append(Href.encode(value));
                }
            }
        }
        if (this.fragment.has()) {
            text.append('#');
            text.append(this.fragment.get());
        }
        return text.toString();
    }

    public String path() {
        return this.uri.getPath();
    }

    public String bare() {
        StringBuilder text = new StringBuilder(this.uri.toString());
        if (this.uri.getPath().isEmpty()) {
            text.append('/');
        }
        return text.toString();
    }

    public Iterable<String> param(Object key) {
        List values = this.params.getOrDefault(key.toString(), Collections.emptyList());
        VerboseIterable<String> iter = values.isEmpty() ? new VerboseIterable(Collections.emptyList(), String.format("there are no URI params by name \"%s\" among %d others", key, this.params.size())) : new VerboseIterable<String>(values, String.format("there are only %d URI params by name \"%s\"", values.size(), key));
        return iter;
    }

    public Href path(Object suffix) {
        return new Href(URI.create(TRAILING_SLASH.matcher(this.uri.toString()).replaceAll("") + '/' + Href.encode(suffix.toString())), this.params, this.fragment);
    }

    public Href with(Object key, Object value) {
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>(this.params);
        if (!map.containsKey(key.toString())) {
            map.put(key.toString(), new LinkedList());
        }
        ((List)map.get(key.toString())).add(value.toString());
        return new Href(this.uri, map, this.fragment);
    }

    public Href without(Object key) {
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>(this.params);
        map.remove(key.toString());
        return new Href(this.uri, map, this.fragment);
    }

    private static String encode(String txt) {
        try {
            return URLEncoder.encode(txt, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String decode(String txt) {
        try {
            return URLDecoder.decode(txt, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static URI createUri(String txt) {
        URI result;
        try {
            result = new URI(txt);
        }
        catch (URISyntaxException ex) {
            int index = ex.getIndex();
            if (index == -1) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
            StringBuilder value = new StringBuilder(txt);
            value.replace(index, index + 1, Href.encode(value.substring(index, index + 1)));
            result = Href.createUri(value.toString());
        }
        return result;
    }

    private static SortedMap<String, List<String>> asMap(String query) {
        TreeMap<String, List<String>> params = new TreeMap<String, List<String>>();
        if (query != null) {
            for (String pair : query.split("&")) {
                String[] parts = pair.split("=", 2);
                String key = Href.decode(parts[0]);
                String value = parts.length > 1 ? Href.decode(parts[1]) : "";
                if (!params.containsKey(key)) {
                    params.put(key, new LinkedList());
                }
                ((List)params.get(key)).add(value);
            }
        }
        return params;
    }

    private static URI createBare(URI link) {
        URI uri;
        if (link.getRawQuery() == null && link.getRawFragment() == null) {
            uri = link;
        } else {
            String href = link.toString();
            int idx = link.getRawQuery() == null ? href.indexOf(35) : href.indexOf(63);
            uri = URI.create(href.substring(0, idx));
        }
        return uri;
    }

    private static Opt<String> readFragment(URI link) {
        Opt<String> fragment = link.getRawFragment() == null ? new Opt.Empty<String>() : new Opt.Single<String>(link.getRawFragment());
        return fragment;
    }
}

