/*
 * Decompiled with CFR 0.152.
 */
package org.takes.misc;

import java.util.Iterator;

public final class Concat<T>
implements Iterable<T> {
    private final Iterable<T> left;
    private final Iterable<T> right;

    public Concat(Iterable<T> aitb, Iterable<T> bitb) {
        this.left = aitb;
        this.right = bitb;
    }

    public String toString() {
        return String.format("%s, %s", this.left, this.right);
    }

    @Override
    public Iterator<T> iterator() {
        return new ConcatIterator<T>(this.left.iterator(), this.right.iterator());
    }

    private static final class ConcatIterator<E>
    implements Iterator<E> {
        private final Iterator<E> left;
        private final Iterator<E> right;

        ConcatIterator(Iterator<E> aitr, Iterator<E> bitr) {
            this.left = aitr;
            this.right = bitr;
        }

        @Override
        public boolean hasNext() {
            return this.left.hasNext() || this.right.hasNext();
        }

        @Override
        public E next() {
            E object = this.left.hasNext() ? this.left.next() : this.right.next();
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterable is immutable and cannot remove anything");
        }
    }
}

