/*
 * Decompiled with CFR 0.152.
 */
package org.takes.http;

import java.io.IOException;
import java.util.Arrays;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.http.Back;
import org.takes.http.BkBasic;
import org.takes.http.BkParallel;
import org.takes.http.BkSafe;
import org.takes.http.BkTimeable;
import org.takes.http.Exit;
import org.takes.http.Front;
import org.takes.http.FtBasic;
import org.takes.http.Options;
import org.takes.rq.RqWithHeader;

public final class FtCli
implements Front {
    private final Take take;
    private final Options options;

    public FtCli(Take tks, String ... args) {
        this(tks, Arrays.asList(args));
    }

    public FtCli(Take tks, Iterable<String> args) {
        this.take = tks;
        this.options = new Options(args);
    }

    @Override
    public void start(final Exit exit) throws IOException {
        Take tks = this.options.hitRefresh() ? new Take(){

            @Override
            public Response act(Request request) throws Exception {
                return FtCli.this.take.act(new RqWithHeader(request, "X-Takes-HitRefresh: yes"));
            }
        } : this.take;
        BkTimeable timeable = new BkTimeable(new BkSafe(new BkBasic(tks)), this.options.maxLatency());
        timeable.setDaemon(true);
        timeable.start();
        final FtBasic front = new FtBasic((Back)new BkParallel((Back)timeable, this.options.threads()), this.options.socket());
        if (this.options.isDaemon()) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        front.start(FtCli.this.exit(exit));
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
            });
            thread.setDaemon(true);
            thread.start();
        } else {
            front.start(this.exit(exit));
        }
    }

    private Exit exit(Exit exit) {
        long start = System.currentTimeMillis();
        long max = this.options.lifetime();
        return new Exit.Or(exit, new Lifetime(start, max));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FtCli)) {
            return false;
        }
        FtCli other = (FtCli)o;
        Take this$take = this.take;
        Take other$take = other.take;
        if (this$take == null ? other$take != null : !this$take.equals(other$take)) {
            return false;
        }
        Options this$options = this.options;
        Options other$options = other.options;
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Take $take = this.take;
        result = result * 59 + ($take == null ? 43 : $take.hashCode());
        Options $options = this.options;
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    private static final class Lifetime
    implements Exit {
        private final long start;
        private final long max;

        Lifetime(long start, long max) {
            this.start = start;
            this.max = max;
        }

        @Override
        public boolean ready() {
            return System.currentTimeMillis() - this.start > this.max;
        }
    }
}

