/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.takes.facets.fork.MediaType;
import org.takes.misc.EnglishLowerCase;

final class MediaTypes {
    private final SortedSet<MediaType> list;

    MediaTypes() {
        this("");
    }

    MediaTypes(String text) {
        this(MediaTypes.parse(text));
    }

    MediaTypes(SortedSet<MediaType> types) {
        this.list = Collections.unmodifiableSortedSet(types);
    }

    public boolean contains(MediaTypes types) {
        boolean contains = false;
        for (MediaType type : types.list) {
            if (!this.contains(type)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public boolean contains(MediaType type) {
        boolean contains = false;
        for (MediaType mine : this.list) {
            if (!mine.matches(type)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public MediaTypes merge(MediaTypes types) {
        TreeSet<MediaType> set = new TreeSet<MediaType>();
        set.addAll(this.list);
        set.addAll(types.list);
        return new MediaTypes(set);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    private static SortedSet<MediaType> parse(String text) {
        TreeSet<MediaType> list = new TreeSet<MediaType>();
        for (String name : new EnglishLowerCase(text).string().split(",")) {
            if (name.isEmpty()) continue;
            list.add(new MediaType(name));
        }
        return list;
    }

    public String toString() {
        return "MediaTypes(list=" + this.list + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaTypes)) {
            return false;
        }
        MediaTypes other = (MediaTypes)o;
        SortedSet<MediaType> this$list = this.list;
        SortedSet<MediaType> other$list = other.list;
        return !(this$list == null ? other$list != null : !this$list.equals(other$list));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SortedSet<MediaType> $list = this.list;
        result = result * 59 + ($list == null ? 43 : $list.hashCode());
        return result;
    }
}

