/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.util.regex.Pattern;
import org.takes.misc.EnglishLowerCase;

final class MediaType
implements Comparable<MediaType> {
    private static final Pattern NON_DIGITS = Pattern.compile("[^0-9\\.]");
    private final Double prio;
    private final String high;
    private final String low;

    MediaType(String text) {
        this.prio = MediaType.priority(text);
        this.high = MediaType.highPart(text);
        this.low = MediaType.lowPart(text);
    }

    @Override
    public int compareTo(MediaType type) {
        int cmp = this.prio.compareTo(type.prio);
        if (cmp == 0 && (cmp = this.high.compareTo(type.high)) == 0) {
            cmp = this.low.compareTo(type.low);
        }
        return cmp;
    }

    public boolean matches(MediaType type) {
        String star = "*";
        return !(!this.high.equals("*") && !type.high.equals("*") && !this.high.equals(type.high) || !this.low.equals("*") && !type.low.equals("*") && !this.low.equals(type.low));
    }

    private static String[] split(String text) {
        return text.split(";", 2);
    }

    private static Double priority(String text) {
        String num;
        String[] parts = MediaType.split(text);
        Double priority = parts.length > 1 ? ((num = NON_DIGITS.matcher(parts[1]).replaceAll("")).isEmpty() ? Double.valueOf(0.0) : Double.valueOf(Double.parseDouble(num))) : Double.valueOf(1.0);
        return priority;
    }

    private static String highPart(String text) {
        return MediaType.sectors(text)[0];
    }

    private static String lowPart(String text) {
        String[] sectors = MediaType.sectors(text);
        String sector = sectors.length > 1 ? sectors[1].trim() : "";
        return sector;
    }

    private static String[] sectors(String text) {
        return new EnglishLowerCase(MediaType.split(text)[0]).string().split("/", 2);
    }

    public String toString() {
        return "MediaType(prio=" + this.prio + ", high=" + this.high + ", low=" + this.low + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)o;
        Double this$prio = this.prio;
        Double other$prio = other.prio;
        if (this$prio == null ? other$prio != null : !((Object)this$prio).equals(other$prio)) {
            return false;
        }
        String this$high = this.high;
        String other$high = other.high;
        if (this$high == null ? other$high != null : !this$high.equals(other$high)) {
            return false;
        }
        String this$low = this.low;
        String other$low = other.low;
        return !(this$low == null ? other$low != null : !this$low.equals(other$low));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $prio = this.prio;
        result = result * 59 + ($prio == null ? 43 : ((Object)$prio).hashCode());
        String $high = this.high;
        result = result * 59 + ($high == null ? 43 : $high.hashCode());
        String $low = this.low;
        result = result * 59 + ($low == null ? 43 : $low.hashCode());
        return result;
    }
}

