/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.io.IOException;
import java.util.List;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.facets.fork.Fork;
import org.takes.facets.fork.MediaTypes;
import org.takes.misc.Opt;
import org.takes.rq.RqHeaders;

public final class FkTypes
implements Fork {
    private final MediaTypes types;
    private final Opt<Response> response;
    private final Opt<Take> take;

    public FkTypes(String list, Response resp) {
        this(list, new Opt.Single<Response>(resp), new Opt.Empty<Take>());
    }

    public FkTypes(String list, Take tke) {
        this(list, new Opt.Empty<Response>(), new Opt.Single<Take>(tke));
    }

    private FkTypes(String list, Opt<Response> resp, Opt<Take> tke) {
        this.types = new MediaTypes(list);
        this.response = resp;
        this.take = tke;
    }

    @Override
    public Opt<Response> route(Request req) throws Exception {
        Opt<Response> resp = FkTypes.accepted(req).contains(this.types) ? (this.response.has() ? new Opt.Single<Response>(this.response.get()) : new Opt.Single<Response>(this.take.get().act(req))) : new Opt.Empty<Response>();
        return resp;
    }

    private static MediaTypes accepted(Request req) throws IOException {
        MediaTypes list = new MediaTypes();
        List<String> headers = new RqHeaders.Base(req).header("Accept");
        for (String hdr : headers) {
            list = list.merge(new MediaTypes(hdr));
        }
        if (list.isEmpty()) {
            list = new MediaTypes("text/html");
        }
        return list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FkTypes)) {
            return false;
        }
        FkTypes other = (FkTypes)o;
        MediaTypes this$types = this.types;
        MediaTypes other$types = other.types;
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        Opt<Response> this$response = this.response;
        Opt<Response> other$response = other.response;
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        Opt<Take> this$take = this.take;
        Opt<Take> other$take = other.take;
        return !(this$take == null ? other$take != null : !this$take.equals(other$take));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MediaTypes $types = this.types;
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        Opt<Response> $response = this.response;
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        Opt<Take> $take = this.take;
        result = result * 59 + ($take == null ? 43 : $take.hashCode());
        return result;
    }
}

