/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.takes.Request;
import org.takes.Response;
import org.takes.Scalar;
import org.takes.Take;
import org.takes.facets.fork.Fork;
import org.takes.facets.fork.RqRegex;
import org.takes.facets.fork.TkRegex;
import org.takes.misc.Opt;
import org.takes.rq.RqHref;
import org.takes.tk.TkFixed;
import org.takes.tk.TkText;

public final class FkRegex
implements Fork {
    private final Pattern pattern;
    private final Scalar<TkRegex> target;

    public FkRegex(String ptn, String text) {
        this(Pattern.compile(ptn, 34), (Take)new TkText(text));
    }

    public FkRegex(String ptn, Response rsp) {
        this(ptn, (Take)new TkFixed(rsp));
    }

    public FkRegex(Pattern ptn, Response rsp) {
        this(ptn, (Take)new TkFixed(rsp));
    }

    public FkRegex(String ptn, Take tke) {
        this(Pattern.compile(ptn, 34), tke);
    }

    public FkRegex(Pattern ptn, final Take tke) {
        this(ptn, new TkRegex(){

            @Override
            public Response act(RqRegex req) throws Exception {
                return tke.act(req);
            }
        });
    }

    public FkRegex(String ptn, TkRegex tke) {
        this(Pattern.compile(ptn, 34), tke);
    }

    public FkRegex(Pattern ptn, final TkRegex tke) {
        this(ptn, new Scalar<TkRegex>(){

            @Override
            public TkRegex get() {
                return tke;
            }
        });
    }

    public FkRegex(Pattern ptn, Scalar<TkRegex> tke) {
        this.pattern = ptn;
        this.target = tke;
    }

    @Override
    public Opt<Response> route(Request req) throws Exception {
        Matcher matcher;
        String path = new RqHref.Base(req).href().path();
        if (path.length() > 1 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        Opt<Response> resp = (matcher = this.pattern.matcher(path)).matches() ? new Opt.Single<Response>(this.target.get().act(new RqMatcher(matcher, req))) : new Opt.Empty<Response>();
        return resp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FkRegex)) {
            return false;
        }
        FkRegex other = (FkRegex)o;
        Pattern this$pattern = this.pattern;
        Pattern other$pattern = other.pattern;
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        Scalar<TkRegex> this$target = this.target;
        Scalar<TkRegex> other$target = other.target;
        return !(this$target == null ? other$target != null : !this$target.equals(other$target));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pattern $pattern = this.pattern;
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        Scalar<TkRegex> $target = this.target;
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        return result;
    }

    private static final class RqMatcher
    implements RqRegex {
        private final Matcher mtr;
        private final Request req;

        RqMatcher(Matcher matcher, Request request) {
            this.mtr = matcher;
            this.req = request;
        }

        @Override
        public Iterable<String> head() throws IOException {
            return this.req.head();
        }

        @Override
        public InputStream body() throws IOException {
            return this.req.body();
        }

        @Override
        public Matcher matcher() {
            return this.mtr;
        }
    }
}

