/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.facets.fork.Fork;
import org.takes.misc.Opt;
import org.takes.rq.RqMethod;
import org.takes.tk.TkFixed;

public final class FkMethods
implements Fork {
    private final Collection<String> methods;
    private final Take take;

    public FkMethods(String mtd, Response rsp) {
        this(mtd, (Take)new TkFixed(rsp));
    }

    public FkMethods(String mtd, Take tke) {
        this(Arrays.asList(mtd.split(",")), tke);
    }

    public FkMethods(Collection<String> mtds, Take tke) {
        this.methods = Collections.unmodifiableCollection(mtds);
        this.take = tke;
    }

    @Override
    public Opt<Response> route(Request req) throws Exception {
        String mtd = new RqMethod.Base(req).method();
        Opt<Response> resp = this.methods.contains(mtd) ? new Opt.Single<Response>(this.take.act(req)) : new Opt.Empty<Response>();
        return resp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FkMethods)) {
            return false;
        }
        FkMethods other = (FkMethods)o;
        Collection<String> this$methods = this.methods;
        Collection<String> other$methods = other.methods;
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        Take this$take = this.take;
        Take other$take = other.take;
        return !(this$take == null ? other$take != null : !this$take.equals(other$take));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<String> $methods = this.methods;
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        Take $take = this.take;
        result = result * 59 + ($take == null ? 43 : $take.hashCode());
        return result;
    }
}

