/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.fork.Fork;
import org.takes.misc.Opt;

public final class FkChain
implements Fork {
    private final Collection<Fork> forks;

    public FkChain() {
        this(Collections.emptyList());
    }

    public FkChain(Fork ... forks) {
        this(Arrays.asList(forks));
    }

    public FkChain(Collection<Fork> forks) {
        this.forks = Collections.unmodifiableCollection(forks);
    }

    @Override
    public Opt<Response> route(Request request) throws Exception {
        Opt<Response> response = new Opt.Empty<Response>();
        for (Fork fork : this.forks) {
            Opt<Response> current = fork.route(request);
            if (!current.has()) continue;
            response = current;
            break;
        }
        return response;
    }
}

