/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.flash;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.takes.Response;
import org.takes.facets.cookies.RsWithCookie;
import org.takes.misc.Expires;
import org.takes.misc.Sprintf;
import org.takes.rs.RsWrap;

public final class RsFlash
extends RsWrap {
    private static final String TEXT_FORMAT = "%s/%s";
    private final CharSequence text;

    public RsFlash(CharSequence msg) throws UnsupportedEncodingException {
        this(msg, Level.INFO);
    }

    public RsFlash(CharSequence msg, Expires.Date expires) throws UnsupportedEncodingException {
        this(msg, Level.INFO, expires);
    }

    public RsFlash(Throwable err) throws UnsupportedEncodingException {
        this(err, new Expires.Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L)));
    }

    public RsFlash(Throwable err, Expires.Date expires) throws UnsupportedEncodingException {
        this(err, Level.SEVERE, expires);
    }

    public RsFlash(Throwable err, Level level) throws UnsupportedEncodingException {
        this((CharSequence)err.getLocalizedMessage(), level, new Expires.Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L)));
    }

    public RsFlash(Throwable err, Level level, Expires.Date expires) throws UnsupportedEncodingException {
        this((CharSequence)err.getLocalizedMessage(), level, expires);
    }

    public RsFlash(CharSequence msg, Level level) throws UnsupportedEncodingException {
        this(msg, level, RsFlash.class.getSimpleName());
    }

    public RsFlash(CharSequence msg, Level level, Expires.Date expires) throws UnsupportedEncodingException {
        this(msg, level, RsFlash.class.getSimpleName(), expires);
    }

    public RsFlash(CharSequence msg, Level level, String cookie) throws UnsupportedEncodingException {
        this(msg, level, cookie, new Expires.Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L)));
    }

    public RsFlash(CharSequence msg, Level level, String cookie, Expires.Date expires) throws UnsupportedEncodingException {
        super(RsFlash.make(msg, level, cookie, expires));
        this.text = String.format(TEXT_FORMAT, level, msg);
    }

    @Override
    public String toString() {
        return String.format("%s(super=%s, text=%s)", RsFlash.class.getSimpleName(), super.toString(), this.text);
    }

    private static Response make(CharSequence msg, Level level, String cookie, Expires.Date expires) throws UnsupportedEncodingException {
        return new RsWithCookie(cookie, (CharSequence)new Sprintf(TEXT_FORMAT, URLEncoder.encode(msg.toString(), Charset.defaultCharset().name()), level.getName()), "Path=/", expires.print());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsFlash)) {
            return false;
        }
        RsFlash other = (RsFlash)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CharSequence this$text = this.text;
        CharSequence other$text = other.text;
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsFlash;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        CharSequence $text = this.text;
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }
}

