/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fallback;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.facets.fallback.Fallback;
import org.takes.facets.fallback.RqFallback;
import org.takes.misc.Opt;
import org.takes.rq.RqHref;
import org.takes.rq.RqMethod;
import org.takes.tk.TkWrap;

public final class TkFallback
extends TkWrap {
    public TkFallback(final Take take, final Fallback fbk) {
        super(new Take(){

            @Override
            public Response act(Request req) throws Exception {
                return TkFallback.route(take, fbk, req);
            }
        });
    }

    private static Response route(Take take, Fallback fbk, Request req) throws Exception {
        Response res;
        long start = System.currentTimeMillis();
        try {
            res = TkFallback.wrap(take.act(req), fbk, req);
        }
        catch (HttpException ex) {
            Opt<Response> fbres = fbk.route(TkFallback.fallback(req, start, ex, ex.code()));
            if (!fbres.has()) {
                throw new IOException(String.format("There is no fallback available in %s", fbk.getClass().getCanonicalName()), TkFallback.error(ex, req, start));
            }
            res = TkFallback.wrap(fbres.get(), fbk, req);
        }
        catch (Throwable ex) {
            Opt<Response> fbres = fbk.route(TkFallback.fallback(req, start, ex, 500));
            if (!fbres.has()) {
                throw new IOException(String.format("There is no fallback available for %s in %s", ex.getClass().getCanonicalName(), fbk.getClass().getCanonicalName()), TkFallback.error(ex, req, start));
            }
            res = TkFallback.wrap(fbres.get(), fbk, req);
        }
        return res;
    }

    private static RqFallback.Fake fallback(Request req, long start, Throwable throwable, int code) throws IOException {
        return new RqFallback.Fake(req, code, TkFallback.error(throwable, req, start));
    }

    private static Response wrap(final Response res, final Fallback fbk, final Request req) {
        return new Response(){

            @Override
            public Iterable<String> head() throws IOException {
                Iterable<String> head;
                long start = System.currentTimeMillis();
                try {
                    head = res.head();
                }
                catch (HttpException ex) {
                    try {
                        head = fbk.route(TkFallback.fallback(req, start, ex, ex.code())).get().head();
                    }
                    catch (Exception exx) {
                        throw (IOException)new IOException(exx).initCause(ex);
                    }
                }
                catch (Throwable ex) {
                    try {
                        head = fbk.route(TkFallback.fallback(req, start, ex, 500)).get().head();
                    }
                    catch (Exception exx) {
                        throw (IOException)new IOException(exx).initCause(ex);
                    }
                }
                return head;
            }

            @Override
            public InputStream body() throws IOException {
                InputStream body;
                long start = System.currentTimeMillis();
                try {
                    body = res.body();
                }
                catch (HttpException ex) {
                    try {
                        body = fbk.route(TkFallback.fallback(req, start, ex, ex.code())).get().body();
                    }
                    catch (Exception exx) {
                        throw (IOException)new IOException(exx).initCause(ex);
                    }
                }
                catch (Throwable ex) {
                    try {
                        body = fbk.route(TkFallback.fallback(req, start, ex, 500)).get().body();
                    }
                    catch (Exception exx) {
                        throw (IOException)new IOException(exx).initCause(ex);
                    }
                }
                return body;
            }
        };
    }

    private static Throwable error(Throwable exp, Request req, long start) throws IOException {
        long msec = System.currentTimeMillis() - start;
        String time = msec < TimeUnit.SECONDS.toMillis(1L) ? String.format("%dms", msec) : String.format("%ds", msec / TimeUnit.SECONDS.toMillis(1L));
        return new IllegalStateException(String.format("[%s %s] failed in %s: %s", new RqMethod.Base(req).method(), new RqHref.Base(req).href(), time, exp.getLocalizedMessage()), exp);
    }

    @Override
    public String toString() {
        return "TkFallback(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TkFallback)) {
            return false;
        }
        TkFallback other = (TkFallback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TkFallback;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

