/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fallback;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.takes.Response;
import org.takes.facets.fallback.Fallback;
import org.takes.facets.fallback.FbWrap;
import org.takes.facets.fallback.RqFallback;
import org.takes.misc.Opt;
import org.takes.misc.Utf8PrintStream;
import org.takes.rq.RqHref;
import org.takes.rq.RqMethod;

public final class FbSlf4j
extends FbWrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(FbSlf4j.class);

    public FbSlf4j() {
        super(new Fallback(){

            @Override
            public Opt<Response> route(RqFallback req) throws IOException {
                FbSlf4j.log(req);
                return new Opt.Empty<Response>();
            }
        });
    }

    private static void log(RqFallback req) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Throwable error = req.throwable();
        try (Utf8PrintStream stream = new Utf8PrintStream(baos, false);){
            error.printStackTrace(stream);
        }
        LOGGER.error("{} {} failed with {}: {}", new RqMethod.Base(req).method(), new RqHref.Base(req).href(), req.code(), baos.toString("UTF-8"));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FbSlf4j)) {
            return false;
        }
        FbSlf4j other = (FbSlf4j)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FbSlf4j;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

