/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.social;

import com.jcabi.http.request.JdkRequest;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.json.JsonObject;
import javax.xml.bind.DatatypeConverter;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.Pass;
import org.takes.misc.Href;
import org.takes.misc.Opt;
import org.takes.misc.Utf8String;

public final class PsTwitter
implements Pass {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String NAME = "name";
    private static final String VERIFY_URL = "https://api.twitter.com/1.1/account/verify_credentials.json";
    private final String app;
    private final String key;
    private final com.jcabi.http.Request token;
    private final com.jcabi.http.Request user;

    public PsTwitter(String name, String keys) {
        this((com.jcabi.http.Request)new JdkRequest(new Href("https://api.twitter.com/oauth2/token").with("grant_type", "client_credentials").toString()), (com.jcabi.http.Request)new JdkRequest(VERIFY_URL), name, keys);
    }

    PsTwitter(com.jcabi.http.Request tkn, com.jcabi.http.Request creds, String name, String keys) {
        this.token = tkn;
        this.user = creds;
        this.app = name;
        this.key = keys;
    }

    @Override
    public Opt<Identity> enter(Request request) throws IOException {
        return new Opt.Single<Identity>(this.identity(this.fetch()));
    }

    @Override
    public Response exit(Response response, Identity identity) {
        return response;
    }

    private Identity identity(String tkn) throws IOException {
        return PsTwitter.parse(((JsonResponse)((RestResponse)this.user.uri().set(URI.create(new Href(VERIFY_URL).with(ACCESS_TOKEN, tkn).toString())).back().header("accept", (Object)"application/json").fetch().as(RestResponse.class)).assertStatus(200).as(JsonResponse.class)).json().readObject());
    }

    private static Identity parse(JsonObject json) {
        HashMap<String, String> props = new HashMap<String, String>(json.size());
        props.put(NAME, json.getString(NAME));
        props.put("picture", json.getString("profile_image_url"));
        return new Identity.Simple(String.format("urn:twitter:%d", json.getInt("id")), props);
    }

    private String fetch() throws IOException {
        return ((JsonResponse)((RestResponse)this.token.method("POST").header("Content-Type", (Object)"application/x-www-form-urlencoded;charset=UTF-8").header("Authorization", (Object)String.format("Basic %s", DatatypeConverter.printBase64Binary(new Utf8String(String.format("%s:%s", this.app, this.key)).asBytes()))).fetch().as(RestResponse.class)).assertStatus(200).as(JsonResponse.class)).json().readObject().getString(ACCESS_TOKEN);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsTwitter)) {
            return false;
        }
        PsTwitter other = (PsTwitter)o;
        String this$app = this.app;
        String other$app = other.app;
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $app = this.app;
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }
}

