/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.signatures;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Formatter;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.takes.facets.auth.signatures.Signature;

public final class SiHmac
implements Signature {
    public static final int HMAC256 = 256;
    public static final int HMAC384 = 384;
    public static final int HMAC512 = 512;
    private final byte[] key;
    private final int bits;

    public SiHmac(String key) {
        this(key.getBytes(Charset.defaultCharset()), 256);
    }

    public SiHmac(String key, int bits) {
        this(key.getBytes(Charset.defaultCharset()), bits);
    }

    public SiHmac(byte[] key, int bits) {
        this.key = (byte[])key.clone();
        this.bits = SiHmac.bitLength(bits);
    }

    @Override
    public byte[] sign(byte[] data) throws IOException {
        return this.encrypt(data);
    }

    public int bitlength() {
        return this.bits;
    }

    private static int bitLength(int bits) {
        int correct = bits;
        if (bits != 256 && bits != 384 && bits != 512) {
            correct = 256;
        }
        return correct;
    }

    private byte[] encrypt(byte[] bytes) throws IOException {
        try (Formatter formatter = new Formatter();){
            for (byte byt : this.create().doFinal(bytes)) {
                formatter.format("%02x", byt);
            }
            byte[] byArray = formatter.toString().getBytes(Charset.defaultCharset());
            return byArray;
        }
    }

    private Mac create() throws IOException {
        String algo = String.format("HmacSHA%s", this.bits);
        try {
            SecretKeySpec secret = new SecretKeySpec(this.key, algo);
            Mac mac = Mac.getInstance(algo);
            mac.init(secret);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new IOException(ex);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiHmac)) {
            return false;
        }
        SiHmac other = (SiHmac)o;
        if (!Arrays.equals(this.key, other.key)) {
            return false;
        }
        return this.bits == other.bits;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.key);
        result = result * 59 + this.bits;
        return result;
    }
}

