/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.codecs;

import java.io.IOException;
import java.util.regex.Pattern;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.codecs.Codec;
import org.takes.facets.auth.codecs.DecodingException;

public final class CcStrict
implements Codec {
    private static final Pattern PTN = Pattern.compile("^(?i)^urn(?-i):[a-zA-Z0-9]([\\-a-zA-Z0-9]{1,31})(:([\\-a-zA-Z0-9/]|%[0-9a-fA-F]{2})*)+(\\?\\w+(=([\\-a-zA-Z0-9/]|%[0-9a-fA-F]{2})*)?(&\\w+(=([\\-a-zA-Z0-9/]|%[0-9a-fA-F]{2})*)?)*)?\\*?$");
    private final Codec origin;

    public CcStrict(Codec codec) {
        this.origin = codec;
    }

    @Override
    public byte[] encode(Identity identity) throws IOException {
        return this.origin.encode(CcStrict.applyRules(identity));
    }

    @Override
    public Identity decode(byte[] bytes) throws IOException {
        return CcStrict.applyRules(this.origin.decode(bytes));
    }

    private static Identity applyRules(Identity identity) {
        if (!identity.equals(Identity.ANONYMOUS)) {
            String urn = identity.urn();
            if (urn.isEmpty()) {
                throw new DecodingException("urn is empty");
            }
            if (!PTN.matcher(urn).matches()) {
                throw new DecodingException(String.format("urn isn't valid: \"%s\"", urn));
            }
        }
        return identity;
    }
}

