/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.codecs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.codecs.Codec;
import org.takes.facets.auth.codecs.DecodingException;

public final class CcHex
implements Codec {
    private static final int CHUNK = 4;
    private static final byte[] BACK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final byte[] FWD = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private final Codec origin;

    public CcHex(Codec codec) {
        this.origin = codec;
    }

    @Override
    public byte[] encode(Identity identity) throws IOException {
        byte[] raw = this.origin.encode(identity);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int idx = 0; idx < raw.length; ++idx) {
            if (idx > 0 && idx % 4 == 0) {
                out.write(45);
            }
            out.write(FWD[raw[idx] >> 4 & 0xF]);
            out.write(FWD[raw[idx] & 0xF]);
        }
        return out.toByteArray();
    }

    @Override
    public Identity decode(byte[] bytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int idx = 0;
        while (idx < bytes.length) {
            if (bytes[idx] == 45) {
                ++idx;
                continue;
            }
            if (idx > bytes.length - 2) {
                throw new DecodingException("not enough data");
            }
            out.write((CcHex.decode(bytes[idx]) << 4) + CcHex.decode(bytes[idx + 1]));
            idx += 2;
        }
        return this.origin.decode(out.toByteArray());
    }

    private static int decode(int hex) {
        if (hex >= BACK.length) {
            throw new DecodingException(String.format("invalid hex char: 0x%2x", hex));
        }
        byte dec = BACK[hex];
        if (dec < 0) {
            throw new DecodingException(String.format("invalid hex character: 0x%2x", hex));
        }
        return dec;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CcHex)) {
            return false;
        }
        CcHex other = (CcHex)o;
        Codec this$origin = this.origin;
        Codec other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Codec $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

