/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Calendar;
import java.util.TimeZone;
import javax.json.Json;
import javax.json.JsonObject;
import org.takes.facets.auth.Identity;

public interface Token {
    public JsonObject json();

    public byte[] encoded() throws IOException;

    public static final class Jwt
    implements Token {
        public static final String SUBJECT = "sub";
        public static final String ISSUED = "iat";
        public static final String EXPIRATION = "exp";
        private static final String ISOFORMAT = "%tFT%<tRZ";
        private final JsonObject jwto;
        private final Calendar now = Calendar.getInstance(TimeZone.getTimeZone("Z"));
        private final Calendar exp = Calendar.getInstance(TimeZone.getTimeZone("Z"));

        public Jwt(Identity idt, long age) {
            this.exp.setTimeInMillis(this.now.getTimeInMillis() + age * 1000L);
            this.jwto = Json.createObjectBuilder().add(ISSUED, String.format(ISOFORMAT, this.now)).add(EXPIRATION, String.format(ISOFORMAT, this.exp)).add(SUBJECT, idt.urn()).build();
        }

        @Override
        public JsonObject json() {
            return this.jwto;
        }

        @Override
        public byte[] encoded() throws IOException {
            return Base64.getEncoder().encode(this.jwto.toString().getBytes(Charset.defaultCharset()));
        }
    }

    public static final class Jose
    implements Token {
        public static final String ALGORITHM = "alg";
        public static final String TYP = "typ";
        private final JsonObject joseo;

        public Jose(int bitlength) {
            this.joseo = Json.createObjectBuilder().add(ALGORITHM, String.format("HS%s", bitlength)).add(TYP, "JWT").build();
        }

        @Override
        public JsonObject json() {
            return this.joseo;
        }

        @Override
        public byte[] encoded() throws IOException {
            return Base64.getEncoder().encode(this.joseo.toString().getBytes(Charset.defaultCharset()));
        }
    }
}

