/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.Pass;
import org.takes.facets.auth.Token;
import org.takes.facets.auth.signatures.SiHmac;
import org.takes.misc.Opt;
import org.takes.rq.RqHeaders;
import org.takes.rs.RsJson;

public final class PsToken
implements Pass {
    private final SiHmac signature;
    private final String header;
    private final long age;

    public PsToken(String key) {
        this(new SiHmac(key, 256), 3600L);
    }

    public PsToken(String key, long seconds) {
        this(new SiHmac(key, 256), seconds);
    }

    private PsToken(SiHmac sign, long seconds) {
        this.header = "Authorization";
        this.signature = sign;
        this.age = seconds;
    }

    @Override
    public Opt<Identity> enter(Request req) throws IOException {
        Iterator<String> headers = new RqHeaders.Base(req).header(this.header).iterator();
        Opt<Identity> user = new Opt.Empty<Identity>();
        String head = "";
        while (headers.hasNext()) {
            String nexthead = headers.next();
            if (!nexthead.trim().startsWith("Bearer")) continue;
            head = nexthead;
            break;
        }
        String dot = "\\.";
        if (!head.isEmpty()) {
            String jwt = head.split(" ", 2)[1].trim();
            String[] parts = jwt.split("\\.");
            byte[] jwtheader = parts[0].getBytes(Charset.defaultCharset());
            byte[] jwtpayload = parts[1].getBytes(Charset.defaultCharset());
            byte[] jwtsign = parts[2].getBytes(Charset.defaultCharset());
            ByteBuffer tocheck = ByteBuffer.allocate(jwtheader.length + jwtpayload.length + 1);
            tocheck.put(jwtheader).put(".".getBytes(Charset.defaultCharset())).put(jwtpayload);
            byte[] checked = this.signature.sign(tocheck.array());
            if (Arrays.equals(jwtsign, checked)) {
                try (JsonReader rdr = Json.createReader((Reader)new StringReader(new String(Base64.getDecoder().decode(jwtpayload), Charset.defaultCharset())));){
                    user = new Opt.Single<Identity.Simple>(new Identity.Simple(rdr.readObject().getString("sub")));
                }
            }
        }
        return user;
    }

    @Override
    public Response exit(Response res, Identity idt) throws Exception {
        byte[] jwtheader = new Token.Jose(this.signature.bitlength()).encoded();
        byte[] jwtpayload = new Token.Jwt(idt, this.age).encoded();
        ByteBuffer tosign = ByteBuffer.allocate(jwtheader.length + jwtpayload.length + 1);
        tosign.put(jwtheader);
        tosign.put(".".getBytes(Charset.defaultCharset()));
        tosign.put(jwtpayload);
        byte[] sign = this.signature.sign(tosign.array());
        try (JsonReader reader = Json.createReader((InputStream)res.body());){
            JsonObject target = Json.createObjectBuilder().add("response", (JsonValue)reader.read()).add("jwt", String.format("%s.%s.%s", new String(jwtheader, Charset.defaultCharset()), new String(jwtpayload, Charset.defaultCharset()), new String(sign, Charset.defaultCharset()))).build();
            RsJson rsJson = new RsJson((JsonStructure)target);
            return rsJson;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsToken)) {
            return false;
        }
        PsToken other = (PsToken)o;
        SiHmac this$signature = this.signature;
        SiHmac other$signature = other.signature;
        if (this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature)) {
            return false;
        }
        String this$header = this.header;
        String other$header = other.header;
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        return this.age == other.age;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SiHmac $signature = this.signature;
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        String $header = this.header;
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        long $age = this.age;
        result = result * 59 + (int)($age >>> 32 ^ $age);
        return result;
    }
}

