/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.Pass;
import org.takes.misc.Opt;
import org.takes.rq.RqHref;

public final class PsByFlag
implements Pass {
    private final String flag;
    private final Map<Pattern, Pass> passes;

    public PsByFlag(Pair ... pairs) {
        this(PsByFlag.class.getSimpleName(), pairs);
    }

    public PsByFlag(Map<Pattern, Pass> map) {
        this(PsByFlag.class.getSimpleName(), map);
    }

    public PsByFlag(String flg, Pair ... pairs) {
        this(flg, PsByFlag.asMap(pairs));
    }

    public PsByFlag(String flg, Map<Pattern, Pass> map) {
        this.flag = flg;
        this.passes = Collections.unmodifiableMap(map);
    }

    @Override
    public Opt<Identity> enter(Request req) throws Exception {
        Iterator<String> flg = new RqHref.Base(req).href().param(this.flag).iterator();
        Opt<Identity> user = new Opt.Empty<Identity>();
        if (flg.hasNext()) {
            String value = flg.next();
            for (Map.Entry<Pattern, Pass> ent : this.passes.entrySet()) {
                if (!ent.getKey().matcher(value).matches()) continue;
                user = ent.getValue().enter(req);
                break;
            }
        }
        return user;
    }

    @Override
    public Response exit(Response response, Identity identity) {
        return response;
    }

    @SafeVarargs
    private static Map<Pattern, Pass> asMap(Map.Entry<Pattern, Pass> ... entries) {
        HashMap<Pattern, Pass> map = new HashMap<Pattern, Pass>(entries.length);
        for (Map.Entry<Pattern, Pass> ent : entries) {
            map.put(ent.getKey(), ent.getValue());
        }
        return map;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsByFlag)) {
            return false;
        }
        PsByFlag other = (PsByFlag)o;
        String this$flag = this.flag;
        String other$flag = other.flag;
        if (this$flag == null ? other$flag != null : !this$flag.equals(other$flag)) {
            return false;
        }
        Map<Pattern, Pass> this$passes = this.passes;
        Map<Pattern, Pass> other$passes = other.passes;
        return !(this$passes == null ? other$passes != null : !((Object)this$passes).equals(other$passes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $flag = this.flag;
        result = result * 59 + ($flag == null ? 43 : $flag.hashCode());
        Map<Pattern, Pass> $passes = this.passes;
        result = result * 59 + ($passes == null ? 43 : ((Object)$passes).hashCode());
        return result;
    }

    public static final class Pair
    extends AbstractMap.SimpleEntry<Pattern, Pass> {
        private static final long serialVersionUID = 7362482770166663015L;

        public Pair(String key, Pass pass) {
            this(Pattern.compile(Pattern.quote(key)), pass);
        }

        public Pair(Pattern key, Pass pass) {
            super(key, pass);
        }
    }
}

