/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import org.cactoos.Func;
import org.cactoos.Scalar;

public final class Ternary<T>
implements Scalar<T> {
    private final Scalar<Boolean> condition;
    private final Scalar<T> consequent;
    private final Scalar<T> alternative;

    public <X> Ternary(X input, Func<X, Boolean> cnd, Func<X, T> cons, Func<X, T> alter) {
        this(() -> (Boolean)cnd.apply(input), () -> cons.apply(input), () -> alter.apply(input));
    }

    public Ternary(boolean cnd, T cons, T alter) {
        this(() -> cnd, cons, alter);
    }

    public Ternary(Scalar<Boolean> cnd, T cons, T alter) {
        this(cnd, () -> cons, () -> alter);
    }

    public Ternary(Scalar<Boolean> cnd, Scalar<T> cons, Scalar<T> alter) {
        this.condition = cnd;
        this.consequent = cons;
        this.alternative = alter;
    }

    @Override
    public T value() throws Exception {
        Scalar<T> result = this.condition.value() != false ? this.consequent : this.alternative;
        return result.value();
    }
}

