/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import java.io.IOException;
import java.util.Iterator;
import org.cactoos.Func;
import org.cactoos.Scalar;
import org.cactoos.scalar.StickyScalar;
import org.cactoos.text.FormattedText;

public final class ItemAt<T>
implements Scalar<T> {
    private final Scalar<T> saved = new StickyScalar<Object>(() -> {
        int cur;
        if (position < 0) {
            throw new IOException(new FormattedText("The position must be non-negative: %d", position).asString());
        }
        Iterator src = (Iterator)iterator.value();
        for (cur = 0; cur < position && src.hasNext(); ++cur) {
            src.next();
        }
        Object ret = cur == position && src.hasNext() ? src.next() : fallback.apply(() -> src);
        return ret;
    });

    public ItemAt(Iterable<T> source) {
        this(source, (Iterable<T> itr) -> {
            throw new IOException("The iterable is empty");
        });
    }

    public ItemAt(T fallback, Iterable<T> source) {
        this(source, (Iterable<T> itr) -> fallback);
    }

    public ItemAt(Iterable<T> source, Func<Iterable<T>, T> fallback) {
        this(source, 0, fallback);
    }

    public ItemAt(int position, Iterable<T> source) {
        this(source, position, (Iterable<T> itr) -> {
            throw new IOException(new FormattedText("The iterable doesn't have the position #%d", position).asString());
        });
    }

    public ItemAt(int position, Iterator<T> source) {
        this(position, () -> source);
    }

    public ItemAt(Iterable<T> source, int position, Func<Iterable<T>, T> fallback) {
        this(new StickyScalar<Iterator<T>>(source::iterator), position, fallback);
    }

    public ItemAt(Iterator<T> iterator) {
        this(iterator, (Iterable<T> itr) -> {
            throw new IOException("Iterator is empty");
        });
    }

    public ItemAt(Iterator<T> iterator, T fallback) {
        this(iterator, (Iterable<T> itr) -> fallback);
    }

    public ItemAt(Iterator<T> iterator, Func<Iterable<T>, T> fallback) {
        this(iterator, 0, fallback);
    }

    public ItemAt(Iterator<T> iterator, int position) {
        this(iterator, position, (Iterable<T> itr) -> {
            throw new IOException(new FormattedText("Iterator doesn't have an element at #%d position", position).asString());
        });
    }

    public ItemAt(Iterator<T> iterator, int position, Func<Iterable<T>, T> fallback) {
        this(new StickyScalar<Iterator<T>>(() -> iterator), position, fallback);
    }

    private ItemAt(Scalar<Iterator<T>> iterator, int position, Func<Iterable<T>, T> fallback) {
    }

    @Override
    public T value() throws Exception {
        return this.saved.value();
    }
}

