/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.map;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cactoos.Func;
import org.cactoos.iterable.IterableOf;
import org.cactoos.iterable.Mapped;
import org.cactoos.map.MapEntry;
import org.cactoos.map.MapEnvelope;
import org.cactoos.map.MapOf;
import org.cactoos.scalar.SyncScalar;

public final class SyncMap<X, Y>
extends MapEnvelope<X, Y> {
    @SafeVarargs
    public SyncMap(Map.Entry<X, Y> ... list) {
        this(new IterableOf<Map.Entry<X, Y>>(list));
    }

    @SafeVarargs
    public SyncMap(Map<X, Y> map, Map.Entry<X, Y> ... list) {
        this(map, new IterableOf<Map.Entry<X, Y>>(list));
    }

    public <Z> SyncMap(Func<Z, X> key, Func<Z, Y> value, Map<X, Y> map, Iterable<Z> list) {
        this((Z item) -> new MapEntry(key.apply(item), value.apply(item)), map, list);
    }

    public <Z> SyncMap(Iterable<Z> list, Func<Z, X> key, Func<Z, Y> value) {
        this((Z item) -> new MapEntry(key.apply(item), value.apply(item)), list);
    }

    @SafeVarargs
    public <Z> SyncMap(Func<Z, Map.Entry<X, Y>> entry, Z ... list) {
        this(new Mapped<Z, Map.Entry<X, Y>>(entry, list));
    }

    public <Z> SyncMap(Func<Z, Map.Entry<X, Y>> entry, Iterable<Z> list) {
        this(new Mapped<Z, Map.Entry<X, Y>>(entry, list));
    }

    public <Z> SyncMap(Func<Z, Map.Entry<X, Y>> entry, Map<X, Y> map, Iterable<Z> list) {
        this(map, new Mapped<Z, Map.Entry<X, Y>>(entry, list));
    }

    public SyncMap(Iterable<Map.Entry<X, Y>> list) {
        this(new MapOf<X, Y>(list));
    }

    public SyncMap(Iterator<Map.Entry<X, Y>> list) {
        this(() -> list);
    }

    public SyncMap(Map<X, Y> map, Iterable<Map.Entry<X, Y>> list) {
        this(new MapOf<X, Y>(map, list));
    }

    public SyncMap(Map<X, Y> map) {
        super(new SyncScalar(() -> {
            ConcurrentHashMap temp = new ConcurrentHashMap(0);
            temp.putAll(map);
            return temp;
        }));
    }
}

