/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public final class IteratorOfBooleans
implements Iterator<Boolean> {
    private final boolean[] list;
    private final AtomicInteger position;

    public IteratorOfBooleans(boolean ... items) {
        this.list = items;
        this.position = new AtomicInteger(0);
    }

    @Override
    public boolean hasNext() {
        return this.position.intValue() < this.list.length;
    }

    @Override
    public Boolean next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator doesn't have any more items");
        }
        return this.list[this.position.getAndIncrement()];
    }
}

