/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class HeadOf<T>
implements Iterator<T> {
    private final Iterator<T> origin;
    private final int head;
    private int current;

    public HeadOf(int num, Iterator<T> iterator) {
        this.origin = iterator;
        this.head = num;
        this.current = 0;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.head && this.origin.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator doesn't have items any more");
        }
        ++this.current;
        return this.origin.next();
    }
}

