/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.cactoos.Func;
import org.cactoos.func.UncheckedFunc;

public final class Filtered<X>
implements Iterator<X> {
    private final Iterator<X> iterator;
    private final Func<X, Boolean> func;
    private final Queue<X> buffer;

    public Filtered(Func<X, Boolean> fnc, Iterator<X> src) {
        this.iterator = src;
        this.func = fnc;
        this.buffer = new LinkedList<X>();
    }

    @Override
    public boolean hasNext() {
        UncheckedFunc<X, Boolean> fnc = new UncheckedFunc<X, Boolean>(this.func);
        if (this.buffer.isEmpty()) {
            while (this.iterator.hasNext()) {
                X object = this.iterator.next();
                if (!fnc.apply(object).booleanValue()) continue;
                this.buffer.add(object);
                break;
            }
        }
        return !this.buffer.isEmpty();
    }

    @Override
    public X next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements that fit the condition");
        }
        return this.buffer.poll();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("#remove() is not supported");
    }
}

