/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.cactoos.Input;
import org.cactoos.io.BytesOf;
import org.cactoos.io.Directory;
import org.cactoos.io.InputOf;

public final class Zip
implements Input {
    private final Directory origin;

    public Zip(Directory origin) {
        this.origin = origin;
    }

    @Override
    public InputStream stream() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ZipOutputStream zip = new ZipOutputStream(out);){
            for (Path path : this.origin) {
                File file = path.toFile();
                ZipEntry entry = new ZipEntry(file.getPath());
                zip.putNextEntry(entry);
                if (file.isFile()) {
                    try (FileInputStream input = new FileInputStream(file);){
                        zip.write(new BytesOf(new InputOf(input)).asBytes());
                    }
                }
                zip.closeEntry();
            }
        }
        return new ByteArrayInputStream(out.toByteArray());
    }
}

