/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

final class WriterAsOutputStream
extends OutputStream {
    private final ByteBuffer input;
    private final CharBuffer output;
    private final Writer writer;
    private final CharsetDecoder decoder;

    WriterAsOutputStream(Writer wtr) {
        this(wtr, StandardCharsets.UTF_8);
    }

    WriterAsOutputStream(Writer wtr, CharSequence charset) {
        this(wtr, charset, 16384);
    }

    WriterAsOutputStream(Writer wtr, Charset charset) {
        this(wtr, charset.name());
    }

    WriterAsOutputStream(Writer wtr, CharSequence charset, int size) {
        this(wtr, Charset.forName(charset.toString()), size);
    }

    WriterAsOutputStream(Writer wtr, int size) {
        this(wtr, StandardCharsets.UTF_8, size);
    }

    WriterAsOutputStream(Writer wtr, Charset charset, int size) {
        this(wtr, charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT), size);
    }

    WriterAsOutputStream(Writer wtr, CharsetDecoder ddr, int size) {
        this.writer = wtr;
        this.decoder = ddr;
        this.input = ByteBuffer.allocate(size);
        this.output = CharBuffer.allocate(size);
    }

    @Override
    public void write(int data) throws IOException {
        this.write(new byte[]{(byte)data}, 0, 1);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        int taken;
        int start = offset;
        for (int left = length; left > 0; left -= taken) {
            taken = this.next(buffer, start, left);
            start += taken;
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private int next(byte[] buffer, int offset, int length) throws IOException {
        CoderResult result;
        int max = Math.min(length, this.input.remaining());
        this.input.put(buffer, offset, max);
        this.input.flip();
        do {
            if ((result = this.decoder.decode(this.input, this.output, false)).isError()) {
                result.throwException();
            }
            this.writer.write(this.output.array(), 0, this.output.position());
            this.writer.flush();
            this.output.rewind();
        } while (!result.isUnderflow());
        this.input.compact();
        return max;
    }
}

