/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.cactoos.Output;
import org.cactoos.io.WriterAsOutputStream;

final class WriterAsOutput
implements Output {
    private final Writer writer;
    private final CharsetDecoder decoder;
    private final int size;

    WriterAsOutput(Writer wtr) {
        this(wtr, StandardCharsets.UTF_8);
    }

    WriterAsOutput(Writer wtr, Charset cset) {
        this(wtr, cset, 16384);
    }

    WriterAsOutput(Writer wtr, Charset cset, int max) {
        this(wtr, cset.newDecoder(), max);
    }

    WriterAsOutput(Writer wtr, CharsetDecoder ddr, int max) {
        this.writer = wtr;
        this.decoder = ddr;
        this.size = max;
    }

    @Override
    public OutputStream stream() {
        return new WriterAsOutputStream(this.writer, this.decoder, this.size);
    }
}

