/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.cactoos.Scalar;
import org.cactoos.Text;
import org.cactoos.scalar.IoCheckedScalar;
import org.cactoos.scalar.StickyScalar;
import org.cactoos.text.TextOf;

public final class TempFile
implements Scalar<Path>,
Closeable {
    private final Scalar<Path> file;

    public TempFile() {
        this("", "");
    }

    public TempFile(String prefix, String suffix) {
        this(() -> Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), prefix, suffix);
    }

    public TempFile(Scalar<Path> dir, String prefix, String suffix) {
        this(dir, new TextOf(prefix), new TextOf(suffix));
    }

    public TempFile(Scalar<Path> dir, Text prefix, Text suffix) {
        this(new StickyScalar<Path>(() -> Files.createTempFile((Path)dir.value(), prefix.asString(), suffix.asString(), new FileAttribute[0])));
    }

    private TempFile(Scalar<Path> fullpath) {
        this.file = fullpath;
    }

    @Override
    public Path value() throws Exception {
        return this.file.value();
    }

    @Override
    public void close() throws IOException {
        Files.delete(new IoCheckedScalar<Path>(this).value());
    }
}

