/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public final class TeeReader
extends Reader {
    private final Reader source;
    private final Writer destination;

    public TeeReader(Reader reader, Writer writer) {
        this.source = reader;
        this.destination = writer;
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        int done = this.source.read(cbuf, 0, length);
        if (done >= 0) {
            this.destination.write(cbuf);
        }
        return done;
    }

    @Override
    public void close() throws IOException {
        try {
            this.source.close();
        }
        finally {
            this.destination.close();
        }
    }
}

