/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.IOException;
import java.io.OutputStream;

public final class TeeOutputStream
extends OutputStream {
    private final OutputStream target;
    private final OutputStream copy;

    public TeeOutputStream(OutputStream tgt, OutputStream cpy) {
        this.target = tgt;
        this.copy = cpy;
    }

    @Override
    public void write(int data) throws IOException {
        try {
            this.target.write(data);
        }
        finally {
            this.copy.write(data);
        }
    }

    @Override
    public void write(byte[] buf) throws IOException {
        try {
            this.target.write(buf);
        }
        finally {
            this.copy.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        try {
            this.target.write(buf, off, len);
        }
        finally {
            this.copy.write(buf, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.target.flush();
        }
        finally {
            this.copy.flush();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.target.close();
        }
        finally {
            this.copy.close();
        }
    }
}

