/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.IOException;
import java.io.InputStream;
import org.cactoos.Func;
import org.cactoos.Input;
import org.cactoos.func.IoCheckedFunc;
import org.cactoos.io.DeadInput;

public final class InputWithFallback
implements Input {
    private final Input main;
    private final IoCheckedFunc<IOException, Input> alternative;

    public InputWithFallback(Input input) {
        this(input, new DeadInput());
    }

    public InputWithFallback(Input input, Input alt) {
        this(input, (IOException error) -> alt);
    }

    public InputWithFallback(Input input, Func<IOException, Input> alt) {
        this(input, new IoCheckedFunc<IOException, Input>(alt));
    }

    public InputWithFallback(Input input, IoCheckedFunc<IOException, Input> alt) {
        this.main = input;
        this.alternative = alt;
    }

    @Override
    public InputStream stream() throws Exception {
        InputStream stream;
        try {
            stream = this.main.stream();
        }
        catch (IOException ex) {
            stream = this.alternative.apply(ex).stream();
        }
        return stream;
    }
}

