/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.cactoos.Bytes;
import org.cactoos.Input;
import org.cactoos.Scalar;
import org.cactoos.Text;
import org.cactoos.io.InputOf;
import org.cactoos.scalar.StickyScalar;
import org.cactoos.scalar.UncheckedScalar;

public final class InputStreamOf
extends InputStream {
    private final UncheckedScalar<InputStream> source;

    public InputStreamOf(Path path) {
        this(new InputOf(path));
    }

    public InputStreamOf(File file) {
        this(new InputOf(file));
    }

    public InputStreamOf(URL url) {
        this(new InputOf(url));
    }

    public InputStreamOf(URI uri) {
        this(new InputOf(uri));
    }

    public InputStreamOf(Bytes bytes) {
        this(new InputOf(bytes));
    }

    public InputStreamOf(byte[] bytes) {
        this(new InputOf(bytes));
    }

    public InputStreamOf(Text text) {
        this(text, StandardCharsets.UTF_8);
    }

    public InputStreamOf(Text text, Charset charset) {
        this(new InputOf(text, charset));
    }

    public InputStreamOf(Text text, CharSequence charset) {
        this(new InputOf(text, charset));
    }

    public InputStreamOf(CharSequence text) {
        this(new InputOf(text));
    }

    public InputStreamOf(CharSequence text, Charset charset) {
        this(new InputOf(text, charset));
    }

    public InputStreamOf(CharSequence text, CharSequence charset) {
        this(new InputOf(text, charset));
    }

    public InputStreamOf(Reader rdr) {
        this(rdr, StandardCharsets.UTF_8);
    }

    public InputStreamOf(Reader rdr, Charset charset) {
        this(new InputOf(rdr, charset));
    }

    public InputStreamOf(Reader rdr, CharSequence charset) {
        this(new InputOf(rdr, charset));
    }

    public InputStreamOf(Reader rdr, Charset cset, int max) {
        this(new InputOf(rdr, cset, max));
    }

    public InputStreamOf(Reader rdr, int max) {
        this(new InputOf(rdr, StandardCharsets.UTF_8, max));
    }

    public InputStreamOf(Reader rdr, CharSequence charset, int max) {
        this(new InputOf(rdr, charset, max));
    }

    public InputStreamOf(Input input) {
        this(input::stream);
    }

    private InputStreamOf(Scalar<InputStream> src) {
        this.source = new UncheckedScalar<InputStream>(new StickyScalar<InputStream>(src));
    }

    @Override
    public int read() throws IOException {
        return this.source.value().read();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.source.value().read(buffer);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.source.value().read(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.source.value().close();
    }

    @Override
    public long skip(long num) throws IOException {
        return this.source.value().skip(num);
    }

    @Override
    public int available() throws IOException {
        return this.source.value().available();
    }

    @Override
    public void mark(int limit) {
        this.source.value().mark(limit);
    }

    @Override
    public void reset() throws IOException {
        this.source.value().reset();
    }

    @Override
    public boolean markSupported() {
        return this.source.value().markSupported();
    }
}

