/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Directory
implements Iterable<Path> {
    private final Path dir;

    public Directory(File file) {
        this(file.toPath());
    }

    public Directory(Path path) {
        this.dir = path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterator<Path> iterator() {
        try (Stream<Path> files = Files.walk(this.dir, new FileVisitOption[0]);){
            Iterator<Path> iterator = files.collect(Collectors.toList()).iterator();
            return iterator;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

