/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.cactoos.Bytes;
import org.cactoos.Input;

public abstract class DigestEnvelope
implements Bytes {
    private final Input source;
    private final int size;
    private final String algorithm;

    public DigestEnvelope(Input input, String algrthm) {
        this(input, 16384, algrthm);
    }

    public DigestEnvelope(Input input, int max, String algrthm) {
        this.source = input;
        this.size = max;
        this.algorithm = algrthm;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] asBytes() throws Exception {
        try (InputStream stream = this.source.stream();){
            MessageDigest msg = MessageDigest.getInstance(this.algorithm);
            byte[] buf = new byte[this.size];
            while (true) {
                int len;
                if ((len = stream.read(buf)) < 0) {
                    byte[] byArray = msg.digest();
                    return byArray;
                }
                msg.update(buf, 0, len);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(ex);
        }
    }
}

