/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator.sample;

import com.github.containersolutions.operator.api.Controller;
import com.github.containersolutions.operator.api.ResourceController;
import com.github.containersolutions.operator.sample.Schema;
import com.github.containersolutions.operator.sample.SchemaStatus;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller(crdName="schemas.mysql.sample.javaoperatorsdk", customResourceClass=Schema.class)
public class SchemaController
implements ResourceController<Schema> {
    static final String USERNAME_FORMAT = "%s-user";
    static final String SECRET_FORMAT = "%s-secret";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final KubernetesClient kubernetesClient;

    public SchemaController(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Schema> createOrUpdateResource(Schema schema) {
        try (Connection connection = this.getConnection();){
            if (!this.schemaExists(connection, schema.getMetadata().getName())) {
                connection.createStatement().execute(String.format("CREATE SCHEMA `%1$s` DEFAULT CHARACTER SET %2$s", schema.getMetadata().getName(), schema.getSpec().getEncoding()));
                String password = RandomStringUtils.randomAlphanumeric(16);
                String userName = String.format(USERNAME_FORMAT, schema.getMetadata().getName());
                String secretName = String.format(SECRET_FORMAT, schema.getMetadata().getName());
                connection.createStatement().execute(String.format("CREATE USER '%1$s' IDENTIFIED BY '%2$s'", userName, password));
                connection.createStatement().execute(String.format("GRANT ALL ON `%1$s`.* TO '%2$s'", schema.getMetadata().getName(), userName));
                Secret credentialsSecret = ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(secretName)).endMetadata()).addToData("MYSQL_USERNAME", Base64.getEncoder().encodeToString(userName.getBytes()))).addToData("MYSQL_PASSWORD", Base64.getEncoder().encodeToString(password.getBytes()))).build();
                ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(schema.getMetadata().getNamespace())).create(credentialsSecret);
                SchemaStatus status = new SchemaStatus();
                status.setUrl(String.format("jdbc:mysql://%1$s/%2$s", System.getenv("MYSQL_HOST"), schema.getMetadata().getName()));
                status.setUserName(userName);
                status.setSecretName(secretName);
                status.setStatus("CREATED");
                schema.setStatus(status);
                this.log.info("Schema {} created", (Object)schema.getMetadata().getName());
                Optional<Schema> optional = Optional.of(schema);
                return optional;
            }
            Optional<Schema> throwable4 = Optional.empty();
            return throwable4;
        }
        catch (SQLException e) {
            this.log.error("Error while creating Schema", e);
            SchemaStatus status = new SchemaStatus();
            status.setUrl(null);
            status.setUserName(null);
            status.setSecretName(null);
            status.setStatus("ERROR");
            schema.setStatus(status);
            return Optional.of(schema);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteResource(Schema schema) {
        this.log.info("Execution deleteResource for: {}", (Object)schema.getMetadata().getName());
        try (Connection connection = this.getConnection();){
            if (this.schemaExists(connection, schema.getMetadata().getName())) {
                connection.createStatement().execute("DROP DATABASE `" + schema.getMetadata().getName() + "`");
                this.log.info("Deleted Schema '{}'", (Object)schema.getMetadata().getName());
                if (this.userExists(connection, schema.getStatus().getUserName())) {
                    connection.createStatement().execute("DROP USER '" + schema.getStatus().getUserName() + "'");
                    this.log.info("Deleted User '{}'", (Object)schema.getStatus().getUserName());
                }
                ((Resource)((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(schema.getMetadata().getNamespace())).withName(schema.getStatus().getSecretName())).delete();
            } else {
                this.log.info("Delete event ignored for schema '{}', real schema doesn't exist", (Object)schema.getMetadata().getName());
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.log.error("Error while trying to delete Schema", e);
            return false;
        }
    }

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection(String.format("jdbc:mysql://%1$s:%2$s?user=%3$s&password=%4$s", System.getenv("MYSQL_HOST"), System.getenv("MYSQL_PORT") != null ? System.getenv("MYSQL_PORT") : "3306", System.getenv("MYSQL_USER"), System.getenv("MYSQL_PASSWORD")));
    }

    private boolean schemaExists(Connection connection, String schemaName) throws SQLException {
        ResultSet resultSet = connection.createStatement().executeQuery(String.format("SELECT schema_name FROM information_schema.schemata WHERE schema_name = \"%1$s\"", schemaName));
        return resultSet.first();
    }

    private boolean userExists(Connection connection, String userName) throws SQLException {
        ResultSet resultSet = connection.createStatement().executeQuery(String.format("SELECT User FROM mysql.user WHERE User='%1$s'", userName));
        return resultSet.first();
    }
}

