/*
 * Decompiled with CFR 0.152.
 */
package com.github.complate;

import com.github.complate.ScriptingEngine;
import com.github.complate.ScriptingException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.util.Map;
import java.util.Optional;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornException;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.springframework.core.io.Resource;

public final class NashornScriptingBridge
implements ScriptingEngine {
    private final NashornScriptEngine engine = NashornScriptingBridge.createEngine();
    private static final String POLYFILLS = "if(typeof global === \"undefined\") {\n    var global = this;\n}\nif(typeof console === \"undefined\") {\n    var console = { log: print, error: print };\n}\n\n";

    public NashornScriptingBridge() {
    }

    public NashornScriptingBridge(Map<String, Object> map) {
        this();
        this.addEngineScopeBindings(map);
    }

    @Override
    public void invoke(Resource resource, String string, Object ... objectArray) throws ScriptingException {
        try (Reader reader = NashornScriptingBridge.readerForScript(resource);){
            this.engine.eval(reader);
        }
        catch (IOException iOException) {
            throw new ScriptingException(String.format("failed to read script from resource '%s'", resource.getDescription()), iOException);
        }
        catch (ScriptException scriptException) {
            throw NashornScriptingBridge.extractJavaScriptError(scriptException).map(string2 -> new ScriptingException("failed to evaluate script", "filepath", string, scriptException, (String)string2)).orElseGet(() -> new ScriptingException("failed to evaluate script", "filepath", string, scriptException));
        }
        try {
            this.engine.invokeFunction(string, objectArray);
        }
        catch (NoSuchMethodException | ScriptException exception) {
            throw NashornScriptingBridge.extractJavaScriptError(exception).map(string2 -> new ScriptingException("failed to invoke function", "filepath", string, exception, (String)string2)).orElseGet(() -> new ScriptingException("failed to invoke function", "filepath", string, exception));
        }
    }

    private static NashornScriptEngine createEngine() {
        ScriptEngine scriptEngine = new NashornScriptEngineFactory().getScriptEngine();
        if (scriptEngine == null) {
            throw new ScriptingException("Cannot instantiate Nashorn Script Engine");
        }
        return (NashornScriptEngine)scriptEngine;
    }

    private static Reader readerForScript(Resource resource) throws IOException {
        InputStream inputStream;
        try {
            inputStream = resource.getInputStream();
        }
        catch (IOException iOException) {
            throw new ScriptingException(String.format("failed to initialize input stream for resource '%s'", resource.getDescription()), iOException);
        }
        InputStream inputStream2 = NashornScriptingBridge.prependPolyfills(inputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream2);
        return new BufferedReader(inputStreamReader);
    }

    private static InputStream prependPolyfills(InputStream inputStream) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(POLYFILLS.getBytes());
        return new SequenceInputStream(byteArrayInputStream, inputStream);
    }

    private static Optional<String> extractJavaScriptError(Exception exception) {
        Throwable throwable = exception.getCause();
        if (throwable instanceof NashornException) {
            return Optional.of(throwable.getMessage() + "\n" + NashornException.getScriptStackString((Throwable)throwable));
        }
        return Optional.empty();
    }

    private void addEngineScopeBindings(Map<String, Object> map) {
        Bindings bindings = this.engine.getBindings(100);
        map.forEach(bindings::put);
    }
}

