/*
 * Decompiled with CFR 0.152.
 */
package com.github.complate;

import com.github.complate.ComplateView;
import com.github.complate.NashornScriptingBridge;
import com.github.complate.ScriptingEngine;
import java.util.Locale;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class ComplateViewResolver
implements ViewResolver {
    public static final Resource DEFAULT_BUNDLE = new ClassPathResource("/templates/complate/bundle.js");
    private final ScriptingEngine scriptingEngine;
    private final Resource bundle;

    public ComplateViewResolver(ScriptingEngine scriptingEngine, Resource resource) {
        Assert.notNull((Object)scriptingEngine, (String)"ScriptingEngine must not be null");
        Assert.notNull((Object)resource, (String)"bundle must not be null");
        this.scriptingEngine = scriptingEngine;
        this.bundle = resource;
    }

    public ComplateViewResolver() {
        this(new NashornScriptingBridge(), DEFAULT_BUNDLE);
    }

    public View resolveViewName(String string, Locale locale) throws Exception {
        return new ComplateView(this.scriptingEngine, this.bundle, string);
    }
}

