/*
 * Decompiled with CFR 0.152.
 */
package com.github.complate;

import com.github.complate.ScriptingEngine;
import com.github.complate.ServletResponseStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.servlet.View;

public class ComplateView
implements View {
    private static final String DEFAULT_CONTENT_TYPE = "text/html; charset=UTF-8";
    private static final String RENDER_FUNCTION_NAME = "render";
    private final ScriptingEngine scriptingEngine;
    private final Resource bundle;
    private final String tag;

    ComplateView(ScriptingEngine scriptingEngine, Resource resource, String string) {
        Assert.notNull((Object)scriptingEngine, (String)"ScriptingEngine must not be null");
        Assert.notNull((Object)resource, (String)"bundle must not be null");
        Assert.notNull((Object)string, (String)"tag must not be null");
        this.scriptingEngine = scriptingEngine;
        this.bundle = resource;
        this.tag = string;
    }

    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    public void render(Map<String, ?> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setContentType(DEFAULT_CONTENT_TYPE);
        ServletResponseStream servletResponseStream = new ServletResponseStream(httpServletResponse);
        this.scriptingEngine.invoke(this.bundle, RENDER_FUNCTION_NAME, servletResponseStream, this.tag, map);
    }
}

