/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingsoldier.paramsvalidate;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.util.StringUtils;

public class ValidateUtils<T>
extends StringUtils {
    private static final Logger LOGGER = Logger.getLogger("@ParamsValidate");

    public static void log(String msg, Method method, Throwable e) {
        msg = method != null ? String.format("ERROR METHOD: %s.%s  Exception Message: %s", method.getDeclaringClass().getName(), method.getName(), msg) : String.format("Exception Message: %s", msg);
        LOGGER.log(Level.SEVERE, msg, e);
    }

    public static void log(Method method, Throwable e) {
        ValidateUtils.log(e.getMessage(), method, e);
    }

    public static void log(Throwable e) {
        ValidateUtils.log(null, e);
    }

    public static boolean isBlank(String str1) {
        return ValidateUtils.isEmpty((Object)str1) || "".equals(str1.trim());
    }

    public static boolean isNotBlank(String str1) {
        return !ValidateUtils.isBlank(str1);
    }

    public static boolean isBlankObj(Object obj) {
        return obj == null || ValidateUtils.isBlank(ValidateUtils.objToStr(obj));
    }

    public static boolean isNotBlankObj(Object obj) {
        return !ValidateUtils.isBlankObj(obj);
    }

    public static boolean strEquals(String str1, String str2) {
        return str1 != null && str2 != null && str1.equals(str2);
    }

    public static boolean strNotBlankEquals(String str1, String str2) {
        return str1 != null && !"".equals(str1) && str2 != null && !"".equals(str2) && str1.equals(str2);
    }

    public static boolean strEqualsIgnoreCase(String str1, String str2) {
        return str1 != null && str2 != null && str1.equalsIgnoreCase(str2);
    }

    public static String objToStr(Object object) {
        String r = "";
        r = object == null ? "" : (object instanceof Number ? new BigDecimal(String.valueOf(object)).toPlainString() : String.valueOf(object));
        return r;
    }

    private static String trimBeginEndCharBase(String args, char beTrim, boolean b, boolean e) {
        int st;
        if (ValidateUtils.isEmpty((Object)args) || ValidateUtils.isEmpty((Object)Character.valueOf(beTrim))) {
            return "";
        }
        int len = args.length();
        char[] val = args.toCharArray();
        char sbeTrim = beTrim;
        if (b) {
            for (st = 0; st < len && val[st] <= sbeTrim; ++st) {
            }
        }
        if (e) {
            while (st < len && val[len - 1] <= sbeTrim) {
                --len;
            }
        }
        return st > 0 || len < args.length() ? args.substring(st, len) : args;
    }

    public static String trimBeginEndChar(String args, char beTrim) {
        return ValidateUtils.trimBeginEndCharBase(args, beTrim, true, true);
    }

    public static String trimBeginChar(String args, char beTrim) {
        return ValidateUtils.trimBeginEndCharBase(args, beTrim, true, false);
    }

    public static boolean isSingleType(Object obj) {
        return obj == null || obj instanceof Number || obj instanceof CharSequence || obj instanceof Character || obj instanceof Date;
    }

    public static boolean isRequest(Map<String, Object> rule) {
        return Boolean.parseBoolean(ValidateUtils.objToStr(rule.get("request")));
    }

    public static double getDouble(Object value) {
        return value instanceof String ? Double.parseDouble(ValidateUtils.objToStr(value)) : ((Number)value).doubleValue();
    }

    public static BigDecimal getBigDecimal(Object value) {
        return new BigDecimal(ValidateUtils.getDouble(value));
    }
}

