/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingsoldier.paramsvalidate;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.codingsoldier.paramsvalidate.ValidateInterface;
import com.github.codingsoldier.paramsvalidate.ValidateUtils;
import com.github.codingsoldier.paramsvalidate.bean.Parser;
import com.github.codingsoldier.paramsvalidate.bean.ResultValidate;
import com.github.codingsoldier.paramsvalidate.bean.ValidateConfig;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidateMain {
    private static volatile Map<String, String> regexCommon;
    public static final String REQUEST = "request";
    public static final String MIN_VALUE = "minValue";
    public static final String MAX_VALUE = "maxValue";
    public static final String MIN_LENGTH = "minLength";
    public static final String MAX_LENGTH = "maxLength";
    public static final String REGEX = "regex";
    public static final String MESSAGE = "message";
    public static final Set<String> RULE_KEY_SET;
    public static final String REGEX_COMMON_JSON = "init.json";
    public static final String REGEX_BEGIN = "REGEX_";
    private Set<String> msgSet;
    private String ruleKey;
    @Autowired
    private ValidateInterface validateInterface;

    public ResultValidate validateEntry(Method method, ValidateConfig validateConfig, Map<String, Object> requestMap) {
        ResultValidate resultValidate = new ResultValidate(true);
        HashMap<String, Object> json = new HashMap();
        try {
            json = this.ruleFileJsonToMap(validateConfig);
        }
        catch (Exception e) {
            resultValidate.setPass(false);
            resultValidate.setMsgSet((Set<String>)new HashSet<String>(){
                {
                    this.add("@ParamsValidate\u8bfb\u53d6\u3001\u89e3\u6790json\u6587\u4ef6\u5931\u8d25");
                }
            });
            ValidateUtils.log(method, e);
        }
        this.msgSet = new TreeSet<String>();
        this.validateExecute(json, requestMap);
        if (this.msgSet.size() > 0) {
            resultValidate.setPass(false);
            this.msgSet.remove("");
            resultValidate.setMsgSet(this.msgSet);
        }
        return resultValidate;
    }

    private void validateExecute(Map<String, Object> json, Map<String, Object> paramMap) {
        if (json == null || json.size() == 0 || paramMap == null || paramMap.size() == 0) {
            return;
        }
        if (RULE_KEY_SET.containsAll(json.keySet())) {
            Iterator<Object> iterator = paramMap.values().iterator();
            if (iterator.hasNext()) {
                Object paramVal = iterator.next();
                this.checkRequest(json, paramVal);
            }
        } else {
            for (String key : json.keySet()) {
                Map jsonVal = (Map)json.get(key);
                Object paramVal = paramMap.get(key);
                this.ruleKey = key;
                Set subKeySet = jsonVal.keySet();
                if (paramVal == null) {
                    this.checkChildRequest(jsonVal);
                    continue;
                }
                if (RULE_KEY_SET.containsAll(subKeySet)) {
                    this.checkRequest(jsonVal, paramVal);
                    continue;
                }
                if (paramVal instanceof List) {
                    for (Object elem : (List)paramVal) {
                        this.validateExecute(jsonVal, (Map)elem);
                    }
                    continue;
                }
                this.validateExecute(jsonVal, (Map)paramVal);
            }
        }
    }

    private void checkChildRequest(Object jsonVal) {
        if (jsonVal instanceof Map) {
            Map jsonRule = (Map)jsonVal;
            Set keySet = jsonRule.keySet();
            if (RULE_KEY_SET.containsAll(keySet) && ValidateUtils.isRequest(jsonRule)) {
                this.msgSet.add(this.messageReturn(jsonRule));
            } else {
                for (String key : keySet) {
                    this.checkChildRequest(jsonRule.get(key));
                }
            }
        }
    }

    private void checkRequest(Map<String, Object> jsonRule, Object paramVal) {
        if (jsonRule == null) {
            return;
        }
        if (ValidateUtils.isRequest(jsonRule)) {
            if (ValidateUtils.isBlankObj(paramVal)) {
                this.msgSet.add(this.messageReturn(jsonRule));
            } else {
                this.paramValToElem(jsonRule, paramVal);
            }
        } else if (ValidateUtils.isNotBlankObj(paramVal)) {
            this.paramValToElem(jsonRule, paramVal);
        }
    }

    private void checkDetail(Map<String, Object> jsonRule, Object val) {
        Object minValue = jsonRule.get(MIN_VALUE);
        Object maxValue = jsonRule.get(MAX_VALUE);
        Object minLength = jsonRule.get(MIN_LENGTH);
        Object maxLength = jsonRule.get(MAX_LENGTH);
        String regex = ValidateUtils.objToStr(jsonRule.get(REGEX));
        if (ValidateUtils.isNotBlankObj(minValue) && ValidateUtils.getDouble(val) < ValidateUtils.getDouble(minValue) || ValidateUtils.isNotBlankObj(maxValue) && ValidateUtils.getBigDecimal(val).compareTo(ValidateUtils.getBigDecimal(maxValue)) >= 1 || ValidateUtils.isNotBlankObj(minLength) && (double)ValidateUtils.objToStr(val).length() < ValidateUtils.getDouble(minLength) || ValidateUtils.isNotBlankObj(maxLength) && (double)ValidateUtils.objToStr(val).length() > ValidateUtils.getDouble(maxLength)) {
            this.msgSet.add(this.messageReturn(jsonRule));
            return;
        }
        if (ValidateUtils.isNotBlank(regex)) {
            if (regex.startsWith(REGEX_BEGIN)) {
                Map<String, String> result = this.getRegexCommon();
                if (result != null && result.size() != 0) {
                    regex = result.get(regex);
                } else {
                    this.msgSet.add("\u521d\u59cb\u5316init.json\u5931\u8d25");
                }
            }
            if (!Pattern.matches(regex, ValidateUtils.objToStr(val))) {
                this.msgSet.add(this.messageReturn(jsonRule));
            }
        }
    }

    private void paramValToElem(Map<String, Object> jsonRule, Object paramVal) {
        if (paramVal instanceof List) {
            for (Object elem : (List)paramVal) {
                this.checkDetail(jsonRule, elem);
            }
        } else {
            this.checkDetail(jsonRule, paramVal);
        }
    }

    private String messageReturn(Map<String, Object> jsonRule) {
        String message = ValidateUtils.objToStr(jsonRule.get(MESSAGE));
        if (ValidateUtils.isBlank(message)) {
            String val = "";
            message = this.ruleKey + "\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u6821\u9a8c\u89c4\u5219\uff1a";
            for (String key : jsonRule.keySet()) {
                val = ValidateUtils.objToStr(jsonRule.get(key));
                if (!ValidateUtils.isNotBlank(val)) continue;
                val = val.startsWith(REGEX_BEGIN) ? regexCommon.get(val) : val;
                message = message + key + "\uff1a" + val + "; ";
            }
            message = message.substring(0, message.length() - 1);
        }
        return message;
    }

    private Map<String, Object> ruleFileJsonToMap(ValidateConfig validateConfig) throws Exception {
        String basePath = this.validateInterface.basePath();
        String filePath = ValidateUtils.trimBeginEndChar(basePath, '/') + "/" + ValidateUtils.trimBeginChar(validateConfig.getFile(), '/');
        Map<String, Object> json = this.validateInterface.getCache(validateConfig);
        if (json == null || json.size() == 0) {
            json = this.ruleFileRead(filePath);
            if (json == null) {
                throw new Exception("@ParamsValidate\u5143\u7d20value\u3001file\u9519\u8bef");
            }
            if (ValidateUtils.isNotBlank(validateConfig.getKeyName())) {
                if ((json = (Map<String, Object>)json.get(validateConfig.getKeyName())) != null) {
                    this.validateInterface.setCache(validateConfig, json);
                } else {
                    throw new Exception("@ParamsValidate\u5143\u7d20keyName\u9519\u8bef");
                }
            }
        }
        return json;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> ruleFileRead(String filePath) throws Exception {
        HashMap hashMap = new HashMap();
        Parser parser = this.validateInterface.getParser();
        try (InputStream is = ValidateUtils.class.getClassLoader().getResourceAsStream(filePath);){
            void var2_7;
            if (is == null) throw new IOException("@ParamsValidate\u8bfb\u53d6file\u5931\u8d25");
            if (parser != null && parser.getParserClass() != null) {
                Class parserClazz = parser.getParserClass();
                Class featureArrClass = parser.getFeatureArrClass();
                if ("com.google.gson.Gson".equals(parserClazz.getName())) {
                    Object gson = parserClazz.newInstance();
                    Method method = parserClazz.getMethod("fromJson", Reader.class, Class.class);
                    Map map = (Map)method.invoke(gson, new InputStreamReader(new BufferedInputStream(is)), Map.class);
                    return var2_7;
                } else {
                    if (!"com.alibaba.fastjson.JSON".equals(parserClazz.getName()) || featureArrClass == null || !"Feature[]".equals(featureArrClass.getSimpleName())) throw new Exception("ValidateInterface#getParser()\u8bbe\u7f6e\u7684\u89e3\u6790\u5668\u4e0d\u7b26\u5408\u89c4\u8303");
                    Method method = parserClazz.getMethod("parseObject", InputStream.class, Type.class, featureArrClass);
                    Map map = (Map)method.invoke(null, is, Map.class, null);
                }
                return var2_7;
            } else {
                ObjectMapper mapper = new ObjectMapper();
                Map map = (Map)mapper.readValue(is, Map.class);
            }
            return var2_7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getRegexCommon() {
        if (regexCommon != null) {
            return regexCommon;
        }
        ValidateMain validateMain = this;
        synchronized (validateMain) {
            ObjectMapper mapper = new ObjectMapper();
            String basePath = this.validateInterface.basePath();
            String filePath = ValidateUtils.trimBeginEndChar(basePath, '/') + "/" + REGEX_COMMON_JSON;
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(filePath);){
                regexCommon = is == null ? null : (Map)mapper.readValue(is, Map.class);
            }
            catch (IOException e) {
                this.msgSet.add("\u521d\u59cb\u5316init.json\u5931\u8d25");
                ValidateUtils.log(e);
            }
        }
        return regexCommon;
    }

    static {
        RULE_KEY_SET = new HashSet<String>(){
            {
                this.add(ValidateMain.REQUEST);
                this.add(ValidateMain.MIN_VALUE);
                this.add(ValidateMain.MAX_VALUE);
                this.add(ValidateMain.MIN_LENGTH);
                this.add(ValidateMain.MAX_LENGTH);
                this.add(ValidateMain.REGEX);
                this.add(ValidateMain.MESSAGE);
            }
        };
    }
}

