/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingsoldier.paramsvalidate;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.codingsoldier.paramsvalidate.ParamsValidate;
import com.github.codingsoldier.paramsvalidate.ValidateInterface;
import com.github.codingsoldier.paramsvalidate.ValidateMain;
import com.github.codingsoldier.paramsvalidate.ValidateUtils;
import com.github.codingsoldier.paramsvalidate.bean.ResultValidate;
import com.github.codingsoldier.paramsvalidate.bean.ValidateConfig;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ValidateAspect {
    public static final String VALIDATE_EXCEPTION_MSG = "\u670d\u52a1\u6682\u4e0d\u53ef\u7528";
    @Autowired
    ValidateMain validateMain;
    @Autowired
    ValidateInterface validateInterface;

    @Pointcut(value="@annotation(com.github.codingsoldier.paramsvalidate.ParamsValidate)")
    public void aspect() {
    }

    @Around(value="aspect()")
    public Object around(JoinPoint joinPoint) throws Throwable {
        Object obj = null;
        ResultValidate resultValidate = this.validateResult(joinPoint);
        obj = resultValidate.isPass() ? ((ProceedingJoinPoint)joinPoint).proceed() : this.validateInterface.validateNotPass(resultValidate);
        return obj;
    }

    private ResultValidate validateResult(JoinPoint joinPoint) {
        ResultValidate resultValidate = new ResultValidate(true);
        Method method = this.getCurrentMethod(joinPoint);
        ValidateConfig validateConfig = this.getConfigs(method);
        if (ValidateUtils.isNotBlank(validateConfig.getFile())) {
            Map<String, Object> allParam = null;
            try {
                allParam = this.mergeParams(joinPoint);
            }
            catch (IOException e) {
                resultValidate.setPass(false);
                resultValidate.setMsgSet((Set<String>)new HashSet<String>(){
                    {
                        this.add("@ParamsValidate\u65e0\u6cd5\u5904\u7406\u8bf7\u6c42\u53c2\u6570");
                    }
                });
                ValidateUtils.log("@ParamsValidate\u65e0\u6cd5\u5904\u7406\u8bf7\u6c42\u53c2\u6570", method, e);
            }
            if (allParam != null) {
                resultValidate = this.validateMain.validateEntry(method, validateConfig, allParam);
            }
        }
        return resultValidate;
    }

    private Method getCurrentMethod(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        return method;
    }

    private ValidateConfig getConfigs(Method method) {
        ValidateConfig validateConfig = new ValidateConfig();
        if (method.getAnnotation(ParamsValidate.class) != null) {
            String file = method.getAnnotation(ParamsValidate.class).value();
            file = ValidateUtils.isNotBlank(file) ? file : method.getAnnotation(ParamsValidate.class).file();
            String keyName = method.getAnnotation(ParamsValidate.class).keyName();
            validateConfig.setFile(file);
            validateConfig.setKeyName(keyName);
        }
        return validateConfig;
    }

    private Object getBodyParam(JoinPoint joinPoint) {
        Object result = null;
        Method method = this.getCurrentMethod(joinPoint);
        Annotation[][] arr2 = method.getParameterAnnotations();
        if (arr2 != null) {
            block0: for (int oi = 0; oi < arr2.length; ++oi) {
                if (arr2[oi] == null) continue;
                for (int ii = 0; ii < arr2[oi].length; ++ii) {
                    if (!"RequestBody".equals(arr2[oi][ii].annotationType().getSimpleName())) continue;
                    result = joinPoint.getArgs()[oi];
                    break block0;
                }
            }
        }
        return result;
    }

    private Map<String, Object> getParamFromRequest(HttpServletRequest request) {
        if (request == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String[] value = null;
        Map paramMap = request.getParameterMap();
        if (paramMap != null) {
            for (String key : paramMap.keySet()) {
                if (!ValidateUtils.isNotBlank(key)) continue;
                value = (String[])paramMap.get(key);
                if (value.length == 1) {
                    resultMap.put(key, value[0]);
                    continue;
                }
                resultMap.put(key, Arrays.asList(value));
            }
        }
        return resultMap;
    }

    private Map<String, Object> mergeParams(JoinPoint joinPoint) throws IOException {
        Object body = this.getBodyParam(joinPoint);
        Map<String, Object> bodyMap = this.bodyParamToMap(body);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Map<String, Object> paramMap = this.getParamFromRequest(request);
        for (String key : bodyMap.keySet()) {
            paramMap.put(key, bodyMap.get(key));
        }
        return paramMap;
    }

    private Map<String, Object> bodyParamToMap(Object obj) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(obj);
        Map result = (Map)mapper.readValue(json, Map.class);
        return result != null ? result : new HashMap();
    }
}

