package com.github.coderahfei.esignspringbootstarter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.coderahfei.esignspringbootstarter.exception.EsignException;
import com.github.coderahfei.esignspringbootstarter.req.*;
import com.github.coderahfei.esignspringbootstarter.res.*;
import com.github.coderahfei.esignspringbootstarter.utils.ESignHelper;
import com.github.coderahfei.esignspringbootstarter.utils.HTTPHelper;
import com.github.coderahfei.esignspringbootstarter.utils.JackJsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * e签宝服务实现类
 *
 * @author yang [yiixuan@163.com]
 */
public class EsignServiceImpl {

    private static final Logger log = LoggerFactory.getLogger(EsignServiceImpl.class);


    public AccountsCreateByThirdPartyUserIdRes createByThirdPartyUserIdForAccounts(AccountsCreateByThirdPartyUserIdReq req) {
        String params = JackJsonUtils.toJson(req);
        AccountsCreateByThirdPartyUserIdRes res = null;
        try {
            res = ESignHelper.sendPost(AccountsCreateByThirdPartyUserIdRes.class, "/v1/accounts/createByThirdPartyUserId", params, "创建个人签署账号");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("创建个人签署账号接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0 || res.getCode() == 53000000) {
            return res;
        } else {
            throw new RuntimeException("创建个人签署账号接口请求失败" + res.getMessage());
        }
    }

    public OrganizationsCreateByThirdPartyUserIdRes createByThirdPartyUserIdForOrganizations(OrganizationsCreateByThirdPartyUserIdReq req) {
        String params = JackJsonUtils.toJson(req);
        OrganizationsCreateByThirdPartyUserIdRes res = null;
        try {
            res = ESignHelper.sendPost(OrganizationsCreateByThirdPartyUserIdRes.class, "/v1/organizations/createByThirdPartyUserId", params, "创建机构签署账号");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("创建个人签署账号接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0 || res.getCode() == 53000000) {
            return res;
        } else {
            throw new RuntimeException("创建个人签署账号接口请求失败" + res.getMessage());
        }
    }

    public FilesGetUploadUrlRes getUploadUrlForFiles(FilesGetUploadUrlReq req, File file) {
        FilesGetUploadUrlRes res = null;
        try {
            String fileName = file.getName();
            String contentMd5 = ESignHelper.getStringContentMD5(file);
            if (req == null) {
                req = new FilesGetUploadUrlReq();
            }
            req.setContentMd5(contentMd5);
            req.setContentType("application/octet-stream");
            req.setFileName(fileName);
            String suffix = fileName.split("\\.")[1];
            req.setFileSize(file.length());
            if (suffix.contains("PDF") || suffix.contains("pdf")) {
                req.setConvert2Pdf(false);
            } else {
                req.setConvert2Pdf(true);
            }
            String params = JackJsonUtils.toJson(req);
            res = ESignHelper.sendPost(FilesGetUploadUrlRes.class, "/v1/files/getUploadUrl", params, "文件上传步骤一");
            //第二步上传文件
            String uploadUrl = res.getData().getUploadUrl();
            Map<String, String> headMap = new HashMap<>();
            headMap.put("Content-MD5", contentMd5);
            headMap.put("Content-Type", "application/octet-stream");
            String result = HTTPHelper.sendPut(uploadUrl, null, file, "UTF-8", headMap);
            log.info("文件上传结果【{}】", result);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("e签宝上传文件模板失败,{}", e);
        }
        return res;
    }

    public FilesStatusRes status(String fileId) {
        FilesStatusRes res = null;
        try {
            res = ESignHelper.sendGet(FilesStatusRes.class, "/v1/files/" + fileId + "/status", "查询文件上传状态");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new EsignException("查询文件上传状态接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0) {
            return res;
        } else {
            throw new EsignException("查询文件上传状态接口请求失败" + res.getMessage());
        }
    }

    public SignflowsRes signflows(SignflowsReq req) {
        String params = JackJsonUtils.toJson(req);
        SignflowsRes res = null;
        try {
            res = ESignHelper.sendPost(SignflowsRes.class, "/v1/signflows", params, "签署流程创建");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("创建个人签署账号接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0 || res.getCode() == 53000000) {
            return res;
        } else {
            throw new RuntimeException("创建个人签署账号接口请求失败" + res.getMessage());
        }
    }

    public SignflowsAttachmentsRes attachments(SignflowsAttachmentsReq req, String flowId) {
        String params = JackJsonUtils.toJson(req);
        SignflowsAttachmentsRes res = null;
        try {
            res = ESignHelper.sendPost(SignflowsAttachmentsRes.class, "/v1/signflows/" + flowId + "/attachments", params, "签署流程创建");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("创建个人签署账号接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0 || res.getCode() == 53000000) {
            return res;
        } else {
            throw new RuntimeException("创建个人签署账号接口请求失败" + res.getMessage());
        }
    }

    public SignflowsSignfieldsHandSignRes signfieldsHandSign(SignflowsSignfieldsHandSignReq req, String flowId) {
        String params = JackJsonUtils.toJson(req);
        SignflowsSignfieldsHandSignRes res = null;
        try {
            res = ESignHelper.sendPost(SignflowsSignfieldsHandSignRes.class, "/v1/signflows/" + flowId + "/signfields/handSign", params, "添加签署方手动盖章签署区");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("创建个人签署账号接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0 || res.getCode() == 53000000) {
            return res;
        } else {
            throw new RuntimeException("创建个人签署账号接口请求失败" + res.getMessage());
        }
    }

    public SignflowsStartRes start(String flowId) {
        SignflowsStartRes put = null;
        try {
            put = ESignHelper.sendPut(SignflowsStartRes.class, "/v1/signflows/" + flowId + "/start", null, "签署流程开启");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return put;
    }

    public SignflowsExecuteUrlRes executeUrl(String flowId, String params) {
        SignflowsExecuteUrlRes put = null;
        try {
            put = ESignHelper.sendGet(SignflowsExecuteUrlRes.class, "/v1/signflows/" + flowId + "/executeUrl?" + params, "签署流程开启");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return put;
    }

    public SignflowsDocumentsRes documents(SignflowsDocumentsReq req, String flowId) {
        String params = JackJsonUtils.toJson(req);
        SignflowsDocumentsRes res = null;
        try {
            res = ESignHelper.sendPost(SignflowsDocumentsRes.class, "/v1/signflows/" + flowId + "/documents", params, "签署流程创建");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("创建个人签署账号接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0 || res.getCode() == 53000000) {
            return res;
        } else {
            throw new RuntimeException("创建个人签署账号接口请求失败" + res.getMessage());
        }
    }


    public AccountsGetThirdIdRes getByThirdIdForAccounts(String thirdPartyUserId) {
        AccountsGetThirdIdRes res = null;
        try {
            res = ESignHelper.sendGet(AccountsGetThirdIdRes.class, "/v1/accounts/getByThirdId?thirdPartyUserId=" + thirdPartyUserId, "查询个人签署账号（通过thirdPartyUserId查询）");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("查询个人签署账号（通过thirdPartyUserId查询）接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0) {
            return res;
        } else {
            throw new RuntimeException("查询个人签署账号（通过thirdPartyUserId查询）接口请求失败" + res.getMessage());
        }
    }

    public OrganizationsGetByThirdIdRes getByThirdIdForOrganizations(String thirdPartyUserId) {
        OrganizationsGetByThirdIdRes res = null;
        try {
            res = ESignHelper.sendGet(OrganizationsGetByThirdIdRes.class, "/v1/organizations/getByThirdId?thirdPartyUserId=" + thirdPartyUserId, "查询机构签署账号（通过thirdPartyUserId查询）");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("查询机构签署账号（通过thirdPartyUserId查询）接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0) {
            return res;
        } else {
            throw new RuntimeException("查询机构签署账号（通过thirdPartyUserId查询）接口请求失败" + res.getMessage());
        }
    }


    public AccountsUpdateByAccountIdRes updateByAccountIdForAccounts(AccountsUpdateByAccountIdReq req, String accountId) {
        String params = JackJsonUtils.toJson(req);
        AccountsUpdateByAccountIdRes res = null;
        try {
            res = ESignHelper.sendPut(AccountsUpdateByAccountIdRes.class, "/v1/accounts/" + accountId, params, "修改个人签署账号（通过accountId修改）");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("修改个人签署账号（通过accountId修改）接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0) {
            return res;
        } else {
            throw new RuntimeException("修改个人签署账号（通过accountId修改）接口请求失败" + res.getMessage());
        }
    }


    public FilesPDFDetailsRes getPDFFileDetails(String fileId) {
        FilesPDFDetailsRes res = null;
        try {
            res = ESignHelper.sendGet(FilesPDFDetailsRes.class, "/v1/files/" + fileId, "查看PDF文件");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("查看PDF文件");
        }
        if (res.getCode() == 0) {
            return res;
        } else {
            throw new RuntimeException("查看PDF文件接口请求失败" + res.getMessage());
        }
    }

    public AccountsLogoutAccountIdRes logoutByAccountId(String accountId) {
        AccountsLogoutAccountIdRes res = null;
        try {
            res = ESignHelper.sendDelete(AccountsLogoutAccountIdRes.class, "/v1/accounts/" + accountId, null, "注销个人签署账号（通过accountId注销）");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("注销个人签署账号（通过accountId注销）接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0) {
            return res;
        } else {
            throw new RuntimeException("注销个人签署账号（通过accountId注销）接口请求失败" + res.getMessage());
        }
    }

    public AccountsLogoutThirdIdRes logoutByThirdId(String thirdPartyUserId) {
        AccountsLogoutThirdIdRes res = null;
        try {
            res = ESignHelper.sendDelete(AccountsLogoutThirdIdRes.class, "/v1/accounts/deleteByThirdId?thirdPartyUserId=" + thirdPartyUserId, null, "注销个人签署账户（通过thirdPartyUserId注销）");
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("注销个人签署账户（通过thirdPartyUserId注销）接口请求e签宝返回结果为空");
        }
        if (res.getCode() == 0) {
            return res;
        } else {
            throw new RuntimeException("注销个人签署账户（通过thirdPartyUserId注销）接口请求失败" + res.getMessage());
        }
    }
}
