package com.github.coderahfei.esignspringbootstarter.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author yang [yiixuan@163.com]
 */
@ConfigurationProperties(prefix = "spring.xia.esign")
public class EsignConfig {

    private Config config = new Config();

    private Url url = new Url();


    public Config getConfig() {
        return config;
    }

    public Url getUrl() {
        return url;
    }

    public static class Url {

        /**
         * 基础支持access_token的URl
         */
        private String accessToken = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&";

        /**
         * 获取公众号用户列表（关注者？）
         */
        private String userList = "https://api.weixin.qq.com/cgi-bin/user/get?";

        /**
         * 创建普通菜单
         */
        private String createMenu = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=";

        /**
         * 批量获取用户基本信息
         */
        private String userInfoBatchget = "https://api.weixin.qq.com/cgi-bin/user/info/batchget?access_token=";
        /**
         * 获取用户基本信息(UnionID机制)
         */
        private String userInfoUnionID = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=";
        /**
         * 批量获取用户基本信息
         */
        private String sendKfMessage = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=";

        /**
         * 生成二维码
         */
        private String createQrcode = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=";
        /**
         * 新增除了（图文类型）之外的其他类型的永久素材
         */
        private String addMaterial = "https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=";
        /**
         * 新增临时素材
         */
        private String mediaUpload = "https://api.weixin.qq.com/cgi-bin/media/upload?access_token=";
        /**
         * 上传图文消息内的图片获取URL
         */
        private String mediaUploadimg = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=";
        /**
         * 上传图文消息
         */
        private String materialAddNews = "https://api.weixin.qq.com/cgi-bin/material/add_news?access_token=";
        /**
         * 创建用户标签
         */
        private String tagsCreate = "https://api.weixin.qq.com/cgi-bin/tags/create?access_token=";
        /**
         * 创建用户标签
         */
        private String tagsUpdate = "https://api.weixin.qq.com/cgi-bin/tags/update?access_token=";
        /**
         * 批量为用户打标签
         */
        private String tagsBatchtagging = "https://api.weixin.qq.com/cgi-bin/tags/members/batchtagging?access_token=";

        /**
         * 长连接转短链接
         */
        private String shortUrl = "https://api.weixin.qq.com/cgi-bin/shorturl?access_token=";


        private String sendTemplateMsg = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";

        public String getSendTemplateMsg() {
            return sendTemplateMsg;
        }

        public Url setSendTemplateMsg(String sendTemplateMsg) {
            this.sendTemplateMsg = sendTemplateMsg;
            return this;
        }

        public String getShortUrl() {
            return shortUrl;
        }

        public Url setShortUrl(String shortUrl) {
            this.shortUrl = shortUrl;
            return this;
        }

        public String getUserInfoUnionID() {
            return userInfoUnionID;
        }

        public Url setUserInfoUnionID(String userInfoUnionID) {
            this.userInfoUnionID = userInfoUnionID;
            return this;
        }

        public String getCreateQrcode() {
            return createQrcode;
        }

        public Url setCreateQrcode(String createQrcode) {
            this.createQrcode = createQrcode;
            return this;
        }

        public String getAccessToken() {
            return accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public String getUserList() {
            return userList;
        }

        public void setUserList(String userList) {
            this.userList = userList;
        }

        public String getCreateMenu() {
            return createMenu;
        }

        public void setCreateMenu(String createMenu) {
            this.createMenu = createMenu;
        }

        public String getUserInfoBatchget() {
            return userInfoBatchget;
        }

        public void setUserInfoBatchget(String userInfoBatchget) {
            this.userInfoBatchget = userInfoBatchget;
        }

        public String getSendKfMessage() {
            return sendKfMessage;
        }

        public void setSendKfMessage(String sendKfMessage) {
            this.sendKfMessage = sendKfMessage;
        }

        public String getAddMaterial() {
            return addMaterial;
        }

        public void setAddMaterial(String addMaterial) {
            this.addMaterial = addMaterial;
        }

        public String getMediaUpload() {
            return mediaUpload;
        }

        public void setMediaUpload(String mediaUpload) {
            this.mediaUpload = mediaUpload;
        }

        public String getMediaUploadimg() {
            return mediaUploadimg;
        }

        public void setMediaUploadimg(String mediaUploadimg) {
            this.mediaUploadimg = mediaUploadimg;
        }

        public String getMaterialAddNews() {
            return materialAddNews;
        }

        public void setMaterialAddNews(String materialAddNews) {
            this.materialAddNews = materialAddNews;
        }

        public String getTagsCreate() {
            return tagsCreate;
        }

        public void setTagsCreate(String tagsCreate) {
            this.tagsCreate = tagsCreate;
        }

        public String getTagsUpdate() {
            return tagsUpdate;
        }

        public void setTagsUpdate(String tagsUpdate) {
            this.tagsUpdate = tagsUpdate;
        }

        public String getTagsBatchtagging() {
            return tagsBatchtagging;
        }

        public void setTagsBatchtagging(String tagsBatchtagging) {
            this.tagsBatchtagging = tagsBatchtagging;
        }
    }

    public static class Config {
        /**
         * 应用 ID
         */
        private String appId = "";

        /**
         * 应用密钥
         */
        private String appKey = "";

        /**
         * 设置域名（默认沙箱环境域名）
         * 正式环境域名 https://openapi.esign.cn
         */
        private String domainName = "";

        public String getDomainName() {
            return domainName;
        }

        public Config setDomainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public String getAppId() {
            return appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getAppKey() {
            return appKey;
        }

        public void setAppKey(String appKey) {
            this.appKey = appKey;
        }
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setUrl(Url url) {
        this.url = url;
    }
}
