package com.github.coderahfei.esignspringbootstarter.config;

import com.github.coderahfei.esignspringbootstarter.EsignUtils;
import com.github.coderahfei.esignspringbootstarter.service.EsignServiceImpl;
import com.github.coderahfei.esignspringbootstarter.utils.ESignHelper;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author yang [yiixuan@163.com]
 */
@Configuration
@EnableConfigurationProperties({EsignConfig.class})
public class EsignAutoConfiguration {

    @Bean
    public EsignServiceImpl esignServiceImpl() {
        return new EsignServiceImpl();
    }

    @Bean
    public ESignHelper eSignHelper(EsignConfig esignConfig) {
        return new ESignHelper(esignConfig);
    }

    @Bean
    public EsignUtils esignUtils() {
        return new EsignUtils(esignServiceImpl());
    }
}
