package com.github.coderahfei.esignspringbootstarter;

import com.github.coderahfei.esignspringbootstarter.req.*;
import com.github.coderahfei.esignspringbootstarter.res.*;
import com.github.coderahfei.esignspringbootstarter.service.EsignServiceImpl;

import java.io.File;

/**
 * e签宝工具
 *
 * @author yang [yiixuan@163.com]
 */
public class EsignUtils {

    private static EsignServiceImpl esignService;

    public EsignUtils(EsignServiceImpl esignService) {
        EsignUtils.esignService = esignService;
    }

    /**
     * 个人签署账号
     */
    public static class Accounts {
        /**
         * 创建个人签署账号
         *
         * @param req 请求参数
         * @return r
         */
        public static AccountsCreateByThirdPartyUserIdRes createByThirdPartyUserId(AccountsCreateByThirdPartyUserIdReq req) {
            return esignService.createByThirdPartyUserIdForAccounts(req);
        }

        /**
         * 修改个人签署账号
         *
         * @param req       请求参数
         * @param accountId 请求参数
         * @return r
         */
        public static AccountsUpdateByAccountIdRes updateByAccountId(AccountsUpdateByAccountIdReq req, String accountId) {
            return esignService.updateByAccountIdForAccounts(req, accountId);
        }

        /**
         * 根据三方id查询个人签署账号
         *
         * @param thirdPartyUserId 三方id
         * @return r
         */
        public static AccountsGetThirdIdRes getByThirdId(String thirdPartyUserId) {
            return esignService.getByThirdIdForAccounts(thirdPartyUserId);
        }

        /**
         * 注销个人签署账号（通过accountId注销）
         *
         * @param accountId
         * @return
         */
        public static AccountsLogoutAccountIdRes logoutByAccountId(String accountId) {
            return esignService.logoutByAccountId(accountId);
        }

        /**
         * 注销个人签署账户（通过thirdPartyUserId注销）
         *
         * @param thirdPartyUserId
         * @return
         */
        public static AccountsLogoutThirdIdRes logoutByThirdId(String thirdPartyUserId) {
            return esignService.logoutByThirdId(thirdPartyUserId);
        }
    }

    /**
     * 机构签署账号
     */
    public static class Organizations {
        /**
         * 创建机构签署账号
         *
         * @param req 请求参数
         * @return r
         */
        public static OrganizationsCreateByThirdPartyUserIdRes createByThirdPartyUserId(OrganizationsCreateByThirdPartyUserIdReq req) {
            return esignService.createByThirdPartyUserIdForOrganizations(req);
        }

        /**
         * 根据三方id查询机构签署账号
         *
         * @param thirdPartyUserId 三方id
         * @return r
         */
        public static OrganizationsGetByThirdIdRes getByThirdId(String thirdPartyUserId) {
            return esignService.getByThirdIdForOrganizations(thirdPartyUserId);
        }
    }

    /**
     * 文件管理
     */
    public static class Files {
        /**
         * 文件上传
         *
         * @param req  请求参数
         * @param file 请求参数
         * @return r
         */
        public static FilesGetUploadUrlRes getUploadUrlForFiles(FilesGetUploadUrlReq req, File file) {
            return esignService.getUploadUrlForFiles(req, file);
        }

        /**
         * 文件状态查询
         *
         * @param fileId 请求参数
         * @return r
         */
        public static FilesStatusRes status(String fileId) {
            return esignService.status(fileId);
        }

        /**
         * PDF 文件详情
         *
         * @param fileId 请求参数
         * @return r
         */
        public static FilesPDFDetailsRes getPDFFileDetails(String fileId) {
            return esignService.getPDFFileDetails(fileId);
        }

    }

    /**
     * 签署服务
     */
    public static class Signflows {
        /**
         * 创建签署流程
         *
         * @param req 请求参数
         * @return r
         */
        public static SignflowsRes signflows(SignflowsReq req) {
            return esignService.signflows(req);
        }

        /**
         * 签署流程开启
         *
         * @param flowId 请求参数
         * @return r
         */
        public static SignflowsStartRes start(String flowId) {
            return esignService.start(flowId);
        }

        /**
         * 流程文档添加
         *
         * @param req    请求参数
         * @param flowId 流程id
         * @return r
         */
        public static SignflowsDocumentsRes documents(SignflowsDocumentsReq req, String flowId) {
            return esignService.documents(req, flowId);
        }

        /**
         * 流程附件添加
         *
         * @param req    请求参数
         * @param flowId 流程id
         * @return r
         */
        public static SignflowsAttachmentsRes attachments(SignflowsAttachmentsReq req, String flowId) {
            return esignService.attachments(req, flowId);
        }

        /**
         * 添加签署方手动盖章签署区
         *
         * @param req    请求参数
         * @param flowId 流程id
         * @return r
         */
        public static SignflowsSignfieldsHandSignRes signfieldsHandSign(SignflowsSignfieldsHandSignReq req, String flowId) {
            return esignService.signfieldsHandSign(req, flowId);
        }

        /**
         * 获取签署地址
         *
         * @param flowId 流程id
         * @param params 请求参数
         * @return r
         */
        public static SignflowsExecuteUrlRes executeUrl(String flowId, String params) {
            return esignService.executeUrl(flowId, params);
        }
    }

}
