/*
 * Decompiled with CFR 0.152.
 */
package com.onestop.ali.nlp.autoconfigure;

import com.onestop.ali.nlp.autoconfigure.OsNlpProperties;
import com.onestop.ali.nlp.util.OsNlpUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={OsNlpProperties.class})
@ConditionalOnProperty(value={"os.nlp.accessKeyId", "os.nlp.accessKeySecret"})
public class OsNlpAutoConfiguration {
    @Autowired
    private OsNlpProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public OsNlpUtils osNlpUtils() {
        OsNlpUtils osNlpUtils = null;
        try {
            osNlpUtils = new OsNlpUtils(this.properties.getAccessKeyId(), this.properties.getAccessKeySecret());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return osNlpUtils;
    }
}

