/*
 * Decompiled with CFR 0.152.
 */
package com.github.choonchernlim.security.adfs.saml2;

import com.github.choonchernlim.betterPreconditions.preconditions.ObjectPreconditions;
import com.github.choonchernlim.betterPreconditions.preconditions.PreconditionFactory;
import com.github.choonchernlim.betterPreconditions.preconditions.StringPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import org.springframework.core.io.Resource;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;

public final class SAMLConfigBean {
    private final String idpServerName;
    private final String spServerName;
    private final Integer spHttpsPort;
    private final String spContextPath;
    private final Resource keystoreResource;
    private final String keystoreAlias;
    private final String keystorePassword;
    private final String keystorePrivateKeyPassword;
    private final String successLoginDefaultUrl;
    private final String successLogoutUrl;
    private final String failedLoginDefaultUrl;
    private final SAMLUserDetailsService samlUserDetailsService;
    private final Boolean storeCsrfTokenInCookie;
    private final Set<String> authnContexts;

    @GeneratePojoBuilder
    SAMLConfigBean(String idpServerName, String spServerName, Integer spHttpsPort, String spContextPath, Resource keystoreResource, String keystoreAlias, String keystorePassword, String keystorePrivateKeyPassword, String successLoginDefaultUrl, String successLogoutUrl, String failedLoginDefaultUrl, Boolean storeCsrfTokenInCookie, SAMLUserDetailsService samlUserDetailsService, Set<String> authnContexts) {
        this.idpServerName = (String)((StringPreconditions)PreconditionFactory.expect((String)idpServerName, (String)"IdP server name").not()).toBeBlank().check();
        this.spServerName = (String)((StringPreconditions)PreconditionFactory.expect((String)spServerName, (String)"Sp server name").not()).toBeBlank().check();
        this.spHttpsPort = (Integer)Optional.fromNullable((Object)spHttpsPort).or((Object)443);
        this.spContextPath = (String)Optional.fromNullable((Object)spContextPath).or((Object)"");
        this.keystoreResource = (Resource)((ObjectPreconditions)((ObjectPreconditions)PreconditionFactory.expect((Object)keystoreResource, (String)"Key store").not()).toBeNull()).check();
        this.keystoreAlias = (String)((StringPreconditions)PreconditionFactory.expect((String)keystoreAlias, (String)"Keystore alias").not()).toBeBlank().check();
        this.keystorePassword = (String)((StringPreconditions)PreconditionFactory.expect((String)keystorePassword, (String)"Keystore password").not()).toBeBlank().check();
        this.keystorePrivateKeyPassword = (String)((StringPreconditions)PreconditionFactory.expect((String)keystorePrivateKeyPassword, (String)"Keystore private key password").not()).toBeBlank().check();
        this.successLoginDefaultUrl = (String)((StringPreconditions)PreconditionFactory.expect((String)successLoginDefaultUrl, (String)"Success login URL").not()).toBeBlank().check();
        this.successLogoutUrl = (String)((StringPreconditions)PreconditionFactory.expect((String)successLogoutUrl, (String)"Success logout URL").not()).toBeBlank().check();
        this.failedLoginDefaultUrl = (String)Optional.fromNullable((Object)failedLoginDefaultUrl).or((Object)"");
        this.storeCsrfTokenInCookie = (Boolean)MoreObjects.firstNonNull((Object)storeCsrfTokenInCookie, (Object)false);
        this.samlUserDetailsService = samlUserDetailsService;
        this.authnContexts = (Set)Optional.fromNullable(authnContexts).or((Object)ImmutableSet.of((Object)"urn:oasis:names:tc:SAML:2.0:ac:classes:Password"));
    }

    public String getIdpServerName() {
        return this.idpServerName;
    }

    public String getSpServerName() {
        return this.spServerName;
    }

    public Integer getSpHttpsPort() {
        return this.spHttpsPort;
    }

    public String getSpContextPath() {
        return this.spContextPath;
    }

    public Resource getKeystoreResource() {
        return this.keystoreResource;
    }

    public String getKeystoreAlias() {
        return this.keystoreAlias;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystorePrivateKeyPassword() {
        return this.keystorePrivateKeyPassword;
    }

    public String getSuccessLoginDefaultUrl() {
        return this.successLoginDefaultUrl;
    }

    public String getSuccessLogoutUrl() {
        return this.successLogoutUrl;
    }

    public String getFailedLoginDefaultUrl() {
        return this.failedLoginDefaultUrl;
    }

    public Boolean getStoreCsrfTokenInCookie() {
        return this.storeCsrfTokenInCookie;
    }

    public SAMLUserDetailsService getSamlUserDetailsService() {
        return this.samlUserDetailsService;
    }

    public Set<String> getAuthnContexts() {
        return this.authnContexts;
    }
}

